/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.copartner.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeUserDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigUserService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeUserDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractListVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CopartnerEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigUserConvert;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeUserDetailConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigUserDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeUserDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigUserDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeUserDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigUserRepo;
import com.elitesland.tw.tw5.server.prd.crm.constant.SystemBasicStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PerformanceReadmeConfigUserServiceImpl
extends BaseServiceImpl
implements PerformanceReadmeConfigUserService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceReadmeConfigUserServiceImpl.class);
    private final PerformanceReadmeConfigUserRepo performanceReadmeConfigUserRepo;
    private final PerformanceReadmeConfigUserDAO performanceReadmeConfigUserDAO;
    private final PerformanceReadmeConfigDAO performanceReadmeConfigDAO;
    private final PerformanceReadmeConfigDetailDAO performanceReadmeConfigDetailDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final PerformanceReadmeUserDetailDAO performanceReadmeUserDetailDAO;
    private final ConAchieveDService conAchieveDService;
    private final PmsProjectService pmsProjectService;
    private final PmsTimesheetService pmsTimesheetService;
    private final SaleConContractService saleConContractService;
    private final CrmOpportunityService crmOpportunityService;
    private final UdcUtil udcUtil;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT);
    }

    public PagingVO<PerformanceReadmeConfigUserVO> queryPaging(PerformanceReadmeConfigUserQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PerformanceReadmeConfigUserVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List vos = this.beanSearcher.searchList(PerformanceReadmeConfigUserVO.class, mapBuilder.build());
        return PagingVO.builder().records(vos).total(total).build();
    }

    private MapBuilder pageWhereBuilder(PerformanceReadmeConfigUserQuery query) {
        String likeStr;
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getConfigId())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getConfigId, new Object[]{query.getConfigId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getUserId, new Object[]{query.getUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyStatus())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getApplyStatus, new Object[]{query.getApplyStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getConfigUserName())) {
            likeStr = "%" + query.getConfigUserName() + "%";
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getConfigUserName, new FieldFns.FieldFn[0])).sql("$1 like ? ", new Object[]{likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstName())) {
            likeStr = "%" + query.getProcInstName() + "%";
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getProcInstName, new FieldFns.FieldFn[0])).sql("$1 like ? ", new Object[]{likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getProcInstStatus, new Object[]{query.getProcInstStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getProcInstId, new Object[]{query.getProcInstId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getBuId())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getBuId, new Object[]{query.getBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getConfigCycle())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getConfigCycle, new Object[]{query.getConfigCycle()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyUserId())) {
            ((MapBuilder)builder.field(PerformanceReadmeConfigUserVO::getApplyUserId, new Object[]{query.getApplyUserId()})).op((FieldOp)FieldOps.Equal);
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public List<PerformanceReadmeConfigUserVO> queryListDynamic(PerformanceReadmeConfigUserQuery query) {
        return this.performanceReadmeConfigUserDAO.queryListDynamic(query);
    }

    public PerformanceReadmeConfigUserVO queryByKey(Long key) {
        PerformanceReadmeConfigUserVO userVO = this.performanceReadmeConfigUserDAO.queryByKey(key);
        List<PerformanceReadmeUserDetailVO> userDetailVOS = this.performanceReadmeUserDetailDAO.queryByConfigUserId(key);
        if (ObjectUtils.isEmpty(userDetailVOS)) {
            PerformanceReadmeConfigVO configVO = this.performanceReadmeConfigDAO.queryByKey(userVO.getConfigId());
            PerformanceReadmeConfigDetailQuery query = new PerformanceReadmeConfigDetailQuery();
            query.setConfigId(configVO.getId());
            List<PerformanceReadmeConfigDetailVO> configDetailVOS = this.performanceReadmeConfigDetailDAO.queryListDynamic(query);
            this.initUserDetail(userVO, configVO, configDetailVOS);
        } else {
            userVO.setPerformanceReadmeUserDetailVOs(userDetailVOS);
        }
        List performanceReadmeUserDetailVOs = this.udcUtil.translateList(userVO.getPerformanceReadmeUserDetailVOs());
        userVO.setPerformanceReadmeUserDetailVOs(performanceReadmeUserDetailVOs);
        return userVO;
    }

    public PerformanceReadmeConfigUserVO querySimpleByKey(Long key) {
        return this.performanceReadmeConfigUserDAO.queryByKey(key);
    }

    public long updateByKeyDynamic(PerformanceReadmeConfigUserPayload payload) {
        return this.performanceReadmeConfigUserDAO.updateByKeyDynamic(payload);
    }

    void initUserDetail(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS) {
        ConAchieveDQuery query = new ConAchieveDQuery();
        ArrayList<LocalDate> dateBetween = new ArrayList<LocalDate>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        query.setSignDate(dateBetween);
        List<String> achieveTypes = Arrays.asList("SIGN", "DELI", "PRE_SALE");
        query.setAchieveTypes(achieveTypes);
        List conAchieveDVOS = this.conAchieveDService.queryListDynamic(query);
        ArrayList<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<PerformanceReadmeUserDetailVO>();
        if (!ObjectUtils.isEmpty((Object)conAchieveDVOS)) {
            List<PerformanceReadmeUserDetailVO> deliDetailVOS = this.handleDeli(userVO, configVO, configDetailVOS, conAchieveDVOS);
            userDetailVOS.addAll(deliDetailVOS);
            List<PerformanceReadmeUserDetailVO> signAndPreSaleDetailVOS = this.handleSignAndPreSale(userVO, configVO, configDetailVOS, conAchieveDVOS);
            userDetailVOS.addAll(signAndPreSaleDetailVOS);
            userDetailVOS.forEach(vo -> vo.setCreateFlag(Integer.valueOf(0)));
        }
        List<PerformanceReadmeUserDetailVO> performanceReadmeUserDetailVOS = this.noAllocationDetailVOs(userVO, configVO, configDetailVOS);
        performanceReadmeUserDetailVOS.forEach(userDetailVO -> {
            if (StringUtils.hasText((String)userDetailVO.getReasonType()) && userDetailVO.getReasonId() != null) {
                userDetailVO.setCreateFlag(Integer.valueOf(1));
                Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo -> vo.getReasonType() != null && vo.getReasonType().equals(userDetailVO.getReasonType()) && vo.getReasonId() != null && vo.getReasonId().equals(userDetailVO.getReasonId())).findFirst();
                if (!first.isPresent()) {
                    userDetailVOS.add((PerformanceReadmeUserDetailVO)userDetailVO);
                }
            }
        });
        userVO.setPerformanceReadmeUserDetailVOs(userDetailVOS);
    }

    List<PerformanceReadmeUserDetailVO> handleSignAndPreSale(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS, List<ConAchieveDVO> conAchieveDVOS) {
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<PerformanceReadmeUserDetailVO>();
        List<String> achieveTypes = Arrays.asList("SIGN", "PRE_SALE");
        List<ConAchieveDVO> dVOs = conAchieveDVOS.stream().filter(dvo -> dvo.getChargeResId().equals(userVO.getUserId()) && achieveTypes.contains(dvo.getAchieveType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(dVOs)) {
            List conIds = dVOs.stream().map(ConAchieveDVO::getSubConId).distinct().collect(Collectors.toList());
            Map<Long, List<ConAchieveDVO>> conMap = conAchieveDVOS.stream().filter(dvo -> conIds.contains(dvo.getSubConId()) && achieveTypes.contains(dvo.getAchieveType())).collect(Collectors.groupingBy(ConAchieveDVO::getSubConId));
            ArrayList dVOIds = new ArrayList();
            conMap.forEach((key, value) -> {
                ConAchieveDVO conAchieveDVO;
                if (value.size() == 1 && StringUtils.hasText((String)(conAchieveDVO = (ConAchieveDVO)value.get(0)).getRatio()) && Integer.valueOf(conAchieveDVO.getRatio()) == 100) {
                    dVOIds.add(conAchieveDVO.getId());
                }
            });
            List preSaleDVOIds = dVOIds.size() > 0 ? dVOs.stream().filter(dvo -> !dVOIds.contains(dvo.getId())).map(BaseViewModel::getId).collect(Collectors.toList()) : dVOs.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            SaleConContractQuery query = new SaleConContractQuery();
            query.setIds(conIds);
            List saleConContractListVOS = this.saleConContractService.queryListDynamic(query);
            List oppoIds = saleConContractListVOS.stream().filter(vo -> vo.getOppoId() != null).map(SaleConContractListVO::getOppoId).collect(Collectors.toList());
            CrmOpportunityQuery queryOppo = new CrmOpportunityQuery();
            queryOppo.setIds(oppoIds);
            List oppoVOS = this.crmOpportunityService.querySimpleList(queryOppo);
            HashMap<Long, Long> conIdMap = new HashMap<Long, Long>();
            saleConContractListVOS.forEach(vo -> {
                Optional<CrmOpportunityListVO> first = oppoVOS.stream().filter(oppoVO -> oppoVO.getId().equals(vo.getOppoId())).findFirst();
                if (first.isPresent()) {
                    conIdMap.put(vo.getId(), first.get().getProjectId());
                }
            });
            String reasonType = PmsReasonTypeEnum.PROJ_OPPO.getCode();
            userDetailVOS = this.getUserDetails(userVO, configVO, dVOs, conIdMap, reasonType);
            PerformanceReadmeConfigDetailVO point1 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point1.getCode())).findFirst().get();
            userDetailVOS.stream().filter(vo -> dVOIds.contains(vo.getAchieveDId())).forEach(vo -> vo.setConfigDetailId(point1.getId()));
            PerformanceReadmeConfigDetailVO point2 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point2.getCode())).findFirst().get();
            userDetailVOS.stream().filter(vo -> preSaleDVOIds.contains(vo.getAchieveDId())).forEach(vo -> vo.setConfigDetailId(point2.getId()));
            userDetailVOS.forEach(userDetailVO -> {
                Optional<SaleConContractListVO> first = saleConContractListVOS.stream().filter(vo -> vo.getId().equals(userDetailVO.getContractId())).findFirst();
                if (first.isPresent()) {
                    String workType = first.get().getWorkType();
                    PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.querySystemSelection("salecon:work_type", workType);
                    userDetailVO.setContractType(prdSystemSelectionVO.getExtString1());
                }
            });
        }
        return userDetailVOS;
    }

    List<PerformanceReadmeUserDetailVO> handleDeli(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS, List<ConAchieveDVO> conAchieveDVOS) {
        List conIds;
        List pmsProjectVOS;
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<PerformanceReadmeUserDetailVO>();
        List<ConAchieveDVO> dVOs = conAchieveDVOS.stream().filter(dvo -> dvo.getChargeResId().equals(userVO.getUserId()) && "DELI".equals(dvo.getAchieveType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(dVOs) && !ObjectUtils.isEmpty((Object)(pmsProjectVOS = this.pmsProjectService.queryByContractIds(conIds = dVOs.stream().map(ConAchieveDVO::getSubConId).distinct().collect(Collectors.toList()))))) {
            Map<Long, Long> conIdMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, PmsProjectVO::getId));
            String reasonType = PmsReasonTypeEnum.PROJ_CONTRACT.getCode();
            userDetailVOS = this.getUserDetails(userVO, configVO, dVOs, conIdMap, reasonType);
            PerformanceReadmeConfigDetailVO point3 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point3.getCode())).findFirst().get();
            userDetailVOS.forEach(vo -> {
                Optional<PmsProjectVO> first;
                vo.setConfigDetailId(point3.getId());
                Long projectId = (Long)conIdMap.get(vo.getContractId());
                if (projectId != null && projectId > 0L && (first = pmsProjectVOS.stream().filter(pmsProjectVO -> pmsProjectVO.getId().equals(projectId)).findFirst()).isPresent()) {
                    PmsProjectVO pmsProjectVO2 = first.get();
                    vo.setProjectId(pmsProjectVO2.getId());
                    vo.setProjectName(pmsProjectVO2.getProjName());
                    PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.querySystemSelection("salecon:work_type", pmsProjectVO2.getWorkType());
                    vo.setContractType(prdSystemSelectionVO.getExtString1());
                }
            });
        }
        return userDetailVOS;
    }

    List<PerformanceReadmeUserDetailVO> getUserDetails(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<ConAchieveDVO> dVOs, Map<Long, Long> conIdMap, String reasonType) {
        ArrayList<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<PerformanceReadmeUserDetailVO>();
        if (conIdMap.isEmpty()) {
            return userDetailVOS;
        }
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsUserId(userVO.getUserId());
        ArrayList<LocalDate> dateBetween = new ArrayList<LocalDate>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        timesheetQuery.setWorkDateBetween(dateBetween);
        timesheetQuery.setReasonType(reasonType);
        timesheetQuery.setReasonIdList(new ArrayList<Long>(conIdMap.values()));
        timesheetQuery.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        List timesheetVOS = this.pmsTimesheetService.queryDaoList(timesheetQuery);
        Map<Long, List<TimesheetVO>> reasonMaps = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getReasonId));
        dVOs.forEach(dVO -> {
            List timesheetVOS1;
            PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
            userDetailVO.setAchieveDId(dVO.getId());
            userDetailVO.setConfigUserId(userVO.getId());
            userDetailVO.setUserId(userVO.getUserId());
            userDetailVO.setConfigId(userVO.getConfigId());
            userDetailVO.setContractId(dVO.getSubConId());
            userDetailVO.setContractName(dVO.getSubConName());
            userDetailVO.setSaleUserId(dVO.getSaleManUserId());
            userDetailVO.setAmount(dVO.getSignAmt());
            userDetailVO.setAmountNoTax(dVO.getEffectiveAmt());
            userDetailVO.setRatio(dVO.getRatio());
            userDetailVO.setAmt(dVO.getAmt());
            BigDecimal workHour = BigDecimal.ZERO;
            Long reasonId = (Long)conIdMap.get(dVO.getSubConId());
            if (reasonId != null && reasonId > 0L && !ObjectUtils.isEmpty((Object)(timesheetVOS1 = (List)reasonMaps.get(reasonId)))) {
                workHour = timesheetVOS1.stream().map(TimesheetVO::getWorkHour).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
            userDetailVO.setDeliDays(workDays);
            userDetailVO.setTotalDays(workDays);
            userDetailVO.setReasonId(reasonId);
            userDetailVO.setReasonType(reasonType);
            userDetailVOS.add(userDetailVO);
        });
        return userDetailVOS;
    }

    List<PerformanceReadmeUserDetailVO> noAllocationDetailVOs(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS) {
        ArrayList<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<PerformanceReadmeUserDetailVO>();
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsUserId(userVO.getUserId());
        ArrayList<LocalDate> dateBetween = new ArrayList<LocalDate>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        timesheetQuery.setWorkDateBetween(dateBetween);
        timesheetQuery.setReasonTypes(Arrays.asList(PmsReasonTypeEnum.PROJ_OPPO.getCode(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode()));
        timesheetQuery.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        List timesheetVOS = this.pmsTimesheetService.queryDaoList(timesheetQuery);
        if (!ObjectUtils.isEmpty((Object)timesheetVOS)) {
            Map<Long, List<TimesheetVO>> reasonProjectMaps;
            Map<Long, List<TimesheetVO>> reasonOppoMaps = timesheetVOS.stream().filter(vo -> vo.getReasonId() != null && StringUtils.hasText((String)vo.getReasonType()) && PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(vo.getReasonType())).collect(Collectors.groupingBy(TimesheetVO::getReasonId));
            if (!reasonOppoMaps.isEmpty()) {
                PerformanceReadmeConfigDetailVO point4 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point4.getCode())).findFirst().get();
                PerformanceReadmeConfigDetailVO point2 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point2.getCode())).findFirst().get();
                CrmOpportunityQuery queryOppo = new CrmOpportunityQuery();
                queryOppo.setProjectIds(new ArrayList<Long>(reasonOppoMaps.keySet()));
                List oppoVOS = this.crmOpportunityService.querySimpleList(queryOppo);
                List oppoIds = oppoVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                SaleConContractQuery query = new SaleConContractQuery();
                query.setOppoIds(oppoIds);
                query.setMainType(SaleConEnum.MAIN.getCode());
                List saleConContractListVOS = this.saleConContractService.queryListDynamic(query);
                Map<Object, Object> collect = new HashMap();
                if (!ObjectUtils.isEmpty((Object)saleConContractListVOS)) {
                    collect = saleConContractListVOS.stream().filter(vo -> !vo.getStatus().equals(SystemBasicStatusEnum.CREATE.getCode())).collect(Collectors.toMap(SaleConContractListVO::getOppoId, Function.identity()));
                }
                HashMap finalCollect = collect;
                oppoVOS.forEach(oppoVO -> {
                    PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
                    if (finalCollect.containsKey(oppoVO.getId())) {
                        SaleConContractListVO saleConContractListVO = (SaleConContractListVO)finalCollect.get(oppoVO.getId());
                        userDetailVO.setConfigDetailId(point2.getId());
                        userDetailVO.setContractId(saleConContractListVO.getId());
                        userDetailVO.setContractName(saleConContractListVO.getName());
                        userDetailVO.setAmount(saleConContractListVO.getAmt());
                        userDetailVO.setAmountNoTax(saleConContractListVO.getEffectiveAmt());
                    } else {
                        userDetailVO.setConfigDetailId(point4.getId());
                        userDetailVO.setAmount(oppoVO.getForecastAmount());
                    }
                    userDetailVO.setConfigUserId(userVO.getId());
                    userDetailVO.setUserId(userVO.getUserId());
                    userDetailVO.setConfigId(userVO.getConfigId());
                    userDetailVO.setSaleUserId(oppoVO.getManageUserId());
                    userDetailVO.setOppoId(oppoVO.getProjectId());
                    userDetailVO.setOppoName(oppoVO.getProjectName());
                    String status = "pre_sale_status1";
                    if (StringUtils.hasText((String)oppoVO.getProjectStatus()) && SystemBasicStatusEnum.ACTIVE.getCode().equals(oppoVO.getProjectStatus())) {
                        status = "pre_sale_status2";
                    }
                    userDetailVO.setOppoStatus(status);
                    BigDecimal workHour = BigDecimal.ZERO;
                    List timesheetVOS1 = (List)reasonOppoMaps.get(oppoVO.getProjectId());
                    if (!ObjectUtils.isEmpty((Object)timesheetVOS1)) {
                        workHour = timesheetVOS1.stream().map(TimesheetVO::getWorkHour).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
                    userDetailVO.setDeliDays(workDays);
                    userDetailVO.setTotalDays(workDays);
                    userDetailVO.setReasonId(oppoVO.getProjectId());
                    userDetailVO.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
                    Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo -> vo.getReasonType().equals(userDetailVO.getReasonType()) && vo.getReasonId().equals(userDetailVO.getReasonId())).findFirst();
                    if (!first.isPresent()) {
                        userDetailVOS.add(userDetailVO);
                    }
                });
            }
            if (!(reasonProjectMaps = timesheetVOS.stream().filter(vo -> vo.getReasonId() != null && StringUtils.hasText((String)vo.getReasonType()) && PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType())).collect(Collectors.groupingBy(TimesheetVO::getReasonId))).isEmpty()) {
                PerformanceReadmeConfigDetailVO point3 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point3.getCode())).findFirst().get();
                List pmsProjectVOS = this.pmsProjectService.queryByKeysSimple(new ArrayList<Long>(reasonProjectMaps.keySet()));
                pmsProjectVOS.forEach(pmsProjectVO -> {
                    PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
                    userDetailVO.setConfigDetailId(point3.getId());
                    userDetailVO.setContractId(pmsProjectVO.getContractId());
                    userDetailVO.setContractName(pmsProjectVO.getContractName());
                    userDetailVO.setConfigUserId(userVO.getId());
                    userDetailVO.setUserId(userVO.getUserId());
                    userDetailVO.setConfigId(userVO.getConfigId());
                    userDetailVO.setSaleUserId(pmsProjectVO.getSaleManUserId());
                    userDetailVO.setAmount(pmsProjectVO.getSumAmt());
                    userDetailVO.setAmountNoTax(pmsProjectVO.getEffectiveAmt());
                    userDetailVO.setProjectId(pmsProjectVO.getId());
                    userDetailVO.setProjectName(pmsProjectVO.getProjName());
                    BigDecimal workHour = BigDecimal.ZERO;
                    List timesheetVOS1 = (List)reasonProjectMaps.get(pmsProjectVO.getId());
                    if (!ObjectUtils.isEmpty((Object)timesheetVOS1)) {
                        workHour = timesheetVOS1.stream().map(TimesheetVO::getWorkHour).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
                    userDetailVO.setDeliDays(workDays);
                    userDetailVO.setTotalDays(workDays);
                    userDetailVO.setReasonId(pmsProjectVO.getId());
                    userDetailVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                    Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo -> vo.getReasonType().equals(userDetailVO.getReasonType()) && vo.getReasonId().equals(userDetailVO.getReasonId())).findFirst();
                    if (!first.isPresent()) {
                        PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.querySystemSelection("salecon:work_type", pmsProjectVO.getWorkType());
                        userDetailVO.setContractType(prdSystemSelectionVO.getExtString1());
                        userDetailVOS.add(userDetailVO);
                    }
                });
            }
        }
        return userDetailVOS;
    }

    public List<PerformanceReadmeConfigUserVO> batchInsert(List<PerformanceReadmeConfigUserPayload> payloads) {
        List<PerformanceReadmeConfigUserDO> entityDos = payloads.stream().map(payload -> {
            PerformanceReadmeConfigUserDO entityDo = PerformanceReadmeConfigUserConvert.INSTANCE.toDo((PerformanceReadmeConfigUserPayload)payload);
            return entityDo;
        }).collect(Collectors.toList());
        List<PerformanceReadmeConfigUserDO> PerformanceReadmeConfigUserDOS = this.performanceReadmeConfigUserDAO.saveAll(entityDos);
        List<PerformanceReadmeConfigUserVO> vos = PerformanceReadmeConfigUserDOS.stream().map(entity -> {
            PerformanceReadmeConfigUserVO vo = PerformanceReadmeConfigUserConvert.INSTANCE.toVo((PerformanceReadmeConfigUserDO)entity);
            return vo;
        }).collect(Collectors.toList());
        return vos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void procInstUpdate(PerformanceReadmeConfigUserPayload payload) {
        String procInstId;
        if (payload.getInitFlag() == null || payload.getInitFlag().booleanValue()) {
            this.handleData(payload);
        }
        if (!StringUtils.hasText((String)(procInstId = payload.getProcInstId()))) {
            this.startProcess(payload);
        } else if (!StringUtils.hasText((String)payload.getProcInstStatus()) || ProcInstStatus.NOTSUBMIT.name().equals(payload.getProcInstStatus()) || ProcInstStatus.REJECTED.name().equals(payload.getProcInstStatus())) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.dealVariables(payload, variables);
            this.workflowUtil.setVariables(SetVariablesPayload.of((String)payload.getProcInstId(), variables));
            payload.setProcInstStatus(ProcInstStatus.APPROVING.name());
        }
        Long buId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getUserId());
        payload.setBuId(buId);
        this.transactionUtilService.executeWithRunnable(() -> this.performanceReadmeConfigUserDAO.updateByKeyDynamic(payload));
    }

    private void handleData(PerformanceReadmeConfigUserPayload payload) {
        List userDetailPayloads = payload.getPerformanceReadmeUserDetailPayloads();
        if (ObjectUtils.isEmpty((Object)userDetailPayloads)) {
            throw TwException.error("", "\u5408\u4f19\u4eba\u7ee9\u6548\u81ea\u8ff0\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        PerformanceReadmeConfigUserVO vo = this.performanceReadmeConfigUserDAO.queryByKey(payload.getId());
        payload.setProcInstId(vo.getProcInstId());
        this.performanceReadmeUserDetailDAO.deleteSoftByConfigUserId(payload.getId());
        List<PerformanceReadmeUserDetailDO> userDetailDOS = userDetailPayloads.stream().map(userDetailPayload -> {
            if (userDetailPayload.getConfigDetailId() == null) {
                throw TwException.error("", "\u5408\u4f19\u4eba\u7ee9\u6548\u81ea\u8ff0\u660e\u7ec6\u914d\u7f6e\u8be6\u60c5\u4e3a\u7a7a");
            }
            userDetailPayload.setConfigId(vo.getConfigId());
            userDetailPayload.setUserId(vo.getUserId());
            userDetailPayload.setConfigUserId(vo.getId());
            PerformanceReadmeUserDetailDO aDo = PerformanceReadmeUserDetailConvert.INSTANCE.toDo((PerformanceReadmeUserDetailPayload)userDetailPayload);
            return aDo;
        }).collect(Collectors.toList());
        this.performanceReadmeUserDetailDAO.saveAll(userDetailDOS);
    }

    void startProcess(PerformanceReadmeConfigUserPayload payload) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.dealVariables(payload, variables);
        String userName = this.cacheUtil.getUserName(payload.getUserId());
        String procInstName = "A40." + payload.getConfigName() + "-" + userName;
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.COPARTNER_REPORT.name(), (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        payload.setId(payload.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload.setProcInstName(procInstName);
    }

    private void dealVariables(PerformanceReadmeConfigUserPayload payload, HashMap<String, Object> variables) {
        variables.put("Activity_0gyegzd", CollUtil.newArrayList((Object[])new Long[]{payload.getUserId()}));
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getUserId());
        variables.put("Activity_1k76zem", CollUtil.newArrayList((Object[])new Long[]{userDefaultOrg.getManageId()}));
        PrdOrgOrganizationRefVO buLevel1 = this.cacheUtil.getBULevel1ByOrgId(userDefaultOrg.getOrgId());
        if (buLevel1 == null) {
            variables.put("Activity_0zj92zg", CollUtil.newArrayList((Object[])new Long[]{userDefaultOrg.getManageId()}));
        } else {
            variables.put("Activity_0zj92zg", CollUtil.newArrayList((Object[])new Long[]{buLevel1.getManageId()}));
        }
        List<Long> vacationAdmin = this.cacheUtil.getUserIdByRoleCodes(CollUtil.newArrayList((Object[])new String[]{RoleEnum.PLAT_HRD.getCode()}));
        variables.put("Activity_17tgayw", vacationAdmin);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.performanceReadmeConfigUserDAO.deleteSoft(keys);
        }
    }

    public void deleteSoftByConfigId(Long configId) {
        this.performanceReadmeConfigUserDAO.deleteSoftByConfigId(configId);
    }

    public PerformanceReadmeConfigUserServiceImpl(PerformanceReadmeConfigUserRepo performanceReadmeConfigUserRepo, PerformanceReadmeConfigUserDAO performanceReadmeConfigUserDAO, PerformanceReadmeConfigDAO performanceReadmeConfigDAO, PerformanceReadmeConfigDetailDAO performanceReadmeConfigDetailDAO, WorkflowUtil workflowUtil, CacheUtil cacheUtil, TransactionUtilService transactionUtilService, PerformanceReadmeUserDetailDAO performanceReadmeUserDetailDAO, ConAchieveDService conAchieveDService, PmsProjectService pmsProjectService, PmsTimesheetService pmsTimesheetService, SaleConContractService saleConContractService, CrmOpportunityService crmOpportunityService, UdcUtil udcUtil) {
        this.performanceReadmeConfigUserRepo = performanceReadmeConfigUserRepo;
        this.performanceReadmeConfigUserDAO = performanceReadmeConfigUserDAO;
        this.performanceReadmeConfigDAO = performanceReadmeConfigDAO;
        this.performanceReadmeConfigDetailDAO = performanceReadmeConfigDetailDAO;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
        this.performanceReadmeUserDetailDAO = performanceReadmeUserDetailDAO;
        this.conAchieveDService = conAchieveDService;
        this.pmsProjectService = pmsProjectService;
        this.pmsTimesheetService = pmsTimesheetService;
        this.saleConContractService = saleConContractService;
        this.crmOpportunityService = crmOpportunityService;
        this.udcUtil = udcUtil;
    }
}

