/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u8fd1\u6d77\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmPotentialCustomerController {
    private static final Logger log = LoggerFactory.getLogger(CrmPotentialCustomerController.class);
    private final CrmPotentialCustomerService service;
    private final CrmFollowService followService;
    private final CrmCommonService crmCommonService;

    @ApiOperation(value="\u65b0\u589e\u548c\u4fee\u6539")
    @PostMapping(value={"/potentialCustomer/saveOne"})
    public TwOutputUtil insert(@RequestBody CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerVO vo = this.service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    @PostMapping(value={"/potentialCustomer/dynamicUpdate"})
    public TwOutputUtil dynamicUpdate(@RequestBody CrmPotentialCustomerPayload payload) {
        this.service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/potentialCustomer/updateProvinceCityDistrict"})
    public TwOutputUtil updateProvinceCityDistrict(@RequestBody CrmPotentialCustomerPayload payload) {
        this.service.updateProvinceCityDistrict(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/potentialCustomer/transfer/opensea"})
    public TwOutputUtil transferPotentialCustomerOpensea(@RequestBody CrmPotentialCustomerPayload payload) {
        this.service.transferPotentialCustomerOpensea(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/potentialCustomer/batchTransfer/opensea"})
    public TwOutputUtil transferPotentialCustomerOpenseaBatch(@RequestBody List<CrmPotentialCustomerPayload> payloads) {
        this.service.transferPotentialCustomerOpenseaBatch(payloads);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/potentialCustomer/transfer/offshore"})
    public TwOutputUtil transferPotentialCustomerOffshore(@RequestBody CrmLeadsDetailPayload payload) {
        return TwOutputUtil.ok(this.service.transferPotentialCustomerOffshore(payload));
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/potentialCustomer/list"})
    public TwOutputUtil queryList(CrmPotentialCustomerQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    @GetMapping(value={"/potentialCustomer/paging"})
    public TwOutputUtil paging(CrmPotentialCustomerQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/potentialCustomer/detail/{id}"})
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmPotentialCustomerVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/potentialCustomer/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deletePotentialCustomerSoft(keys);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/potentialCustomer/follow/list"})
    public TwOutputUtil queryFollowList(@RequestParam Long potentialCustomerId) {
        return TwOutputUtil.ok(this.followService.queryFollowList(potentialCustomerId, CrmFollowObjectEnum.Potential_customer.name()));
    }

    @PostMapping(value={"/potentialCustomer/follow/saveOne"})
    public TwOutputUtil updateFollow(@RequestBody CrmFollowPayload payload) {
        this.service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/potentialCustomer/log/list/{potentialCustomerId}"})
    public TwOutputUtil queryLogList(@PathVariable Long potentialCustomerId) {
        return TwOutputUtil.ok(this.service.queryLogList(potentialCustomerId));
    }

    @GetMapping(value={"/potentialCustomer/log/paging"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(this.service.pageLog(query));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/potentialCustomer/batchExport"})
    public void batchExport(HttpServletResponse response, CrmPotentialCustomerQuery query) {
        this.service.downloadBatch(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/potentialCustomer/batchImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImport(HttpServletResponse response, MultipartFile file, Boolean force) {
        Map resultMap = this.service.importBatch(response, file, force);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok();
        }
        if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        }
        return TwOutputUtil.error("", "", resultMap);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/potentialCustomer/batchImportPro"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImportPro(MultipartFile file, Boolean force) throws InterruptedException {
        Map resultMap = this.service.importBatchPro(file, force);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok();
        }
        if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        }
        return TwOutputUtil.error("", "", resultMap);
    }

    @GetMapping(value={"/potentialCustomer/batchAddTags"})
    public TwOutputUtil batchAddTags(Long[] keys, String tagIds) {
        this.service.batchAddTags(keys, tagIds);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/potentialCustomer/batchDelTags"})
    public TwOutputUtil batchDelTags(Long[] keys, String tagIds) {
        this.service.batchDelTags(keys, tagIds);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/potentialCustomer/checkRepeat"})
    public TwOutputUtil checkRepeat(String type, String checkValue) {
        List repeatMessage = this.crmCommonService.checkRepeat(type, checkValue);
        if (repeatMessage == null || repeatMessage.isEmpty()) {
            return TwOutputUtil.ok();
        }
        return TwOutputUtil.ok("", "", repeatMessage);
    }

    public CrmPotentialCustomerController(CrmPotentialCustomerService service, CrmFollowService followService, CrmCommonService crmCommonService) {
        this.service = service;
        this.followService = followService;
        this.crmCommonService = crmCommonService;
    }
}

