/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.callback;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.OfferEntryApplyProcPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.OfferEntryApplyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/OFFER_ENTRY/callBack"})
@Transactional
public class PersonEntryWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PersonEntryWorkflowCallBackController.class);
    private final PrdOrgPersonDAO dao;
    private final PrdInternalRecommService prdInternalRecommService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final OfferEntryApplyDAO offerEntryApplyDAO;
    private final ResEntryExitLogService entryExitLogService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
        Long applyId = Long.valueOf(businessKey);
        OfferEntryApplyProcPayload offerEntryApplyProcPayload = new OfferEntryApplyProcPayload();
        offerEntryApplyProcPayload.setId(applyId);
        OfferEntryApplyVO offerEntryApplyVO = this.offerEntryApplyDAO.queryByKey(applyId);
        prdOrgPersonPayload.setId(offerEntryApplyVO.getPersonId());
        switch (procInstStatus) {
            case NOTSUBMIT: {
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            }
            case INTERRUPT: 
            case INVALID: {
                prdOrgPersonPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                offerEntryApplyProcPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                break;
            }
            case REJECTED: {
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                break;
            }
            case APPROVED: {
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                prdOrgPersonPayload.setApprovedTime(LocalDateTime.now());
                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                offerEntryApplyProcPayload.setApprovedTime(LocalDateTime.now());
                PrdOrgEmployeeDO prdOrgEmployeeDO = this.dao.findEmployeeByPersonId(offerEntryApplyVO.getPersonId());
                Long employeeId = prdOrgEmployeeDO.getId();
                PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
                prdOrgEmployeePayload.setId(employeeId);
                prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                this.employeeDAO.updateProcessDate(prdOrgEmployeePayload);
                PrdInternalRecommPayload prdInternalRecommPayload = new PrdInternalRecommPayload();
                prdInternalRecommPayload.setPersonId(prdOrgPersonPayload.getId());
                prdInternalRecommPayload.setEntryFlag(Boolean.valueOf(true));
                Boolean res = this.prdInternalRecommService.updateByPersonId(prdInternalRecommPayload);
                ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
                resEntryExitLogPayload.setEmployeeId(employeeId);
                resEntryExitLogPayload.setEntryExitDate(offerEntryApplyVO.getEnrollDate().toString());
                resEntryExitLogPayload.setReasonType1("OFFER_ENTRY_APPLY");
                resEntryExitLogPayload.setReasonType2(offerEntryApplyVO.getEntryType());
                resEntryExitLogPayload.setResType(offerEntryApplyVO.getExtString6());
                resEntryExitLogPayload.setBookId(offerEntryApplyVO.getBookId());
                resEntryExitLogPayload.setOrgId(offerEntryApplyVO.getOrgId());
                resEntryExitLogPayload.setBaseCity(offerEntryApplyVO.getExtString5());
                resEntryExitLogPayload.setCoopType(offerEntryApplyVO.getCooperationMode());
                resEntryExitLogPayload.setJob(offerEntryApplyVO.getJobs());
                this.entryExitLogService.save(resEntryExitLogPayload);
                break;
            }
            case APPROVING: {
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
        }
        this.offerEntryApplyDAO.updateProcStatus(offerEntryApplyProcPayload);
        this.dao.updateProcessDate(prdOrgPersonPayload);
        return WorkflowResult.success(null);
    }

    public PersonEntryWorkflowCallBackController(PrdOrgPersonDAO dao, PrdInternalRecommService prdInternalRecommService, PrdOrgEmployeeDAO employeeDAO, OfferEntryApplyDAO offerEntryApplyDAO, ResEntryExitLogService entryExitLogService) {
        this.dao = dao;
        this.prdInternalRecommService = prdInternalRecommService;
        this.employeeDAO = employeeDAO;
        this.offerEntryApplyDAO = offerEntryApplyDAO;
        this.entryExitLogService = entryExitLogService;
    }
}

