/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.PrdOrgEmployeeConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdOrgEmployeeConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutJsonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.PrdOrgEmployeeConfigTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.PrdOrgEmployeeConfigConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdOrgEmployeeConfigDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdOrgEmployeeConfigDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdOrgEmployeeConfigRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdSystemShortcutIconTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdOrgEmployeeConfigServiceImpl
extends BaseServiceImpl
implements PrdOrgEmployeeConfigService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeConfigServiceImpl.class);
    private final PrdOrgEmployeeConfigRepo prdOrgEmployeeConfigRepo;
    private final PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemShortcutService prdSystemShortcutService;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";

    public PagingVO<PrdOrgEmployeeConfigVO> queryPaging(PrdOrgEmployeeConfigQuery query) {
        return this.prdOrgEmployeeConfigDAO.queryPaging(query);
    }

    public List<PrdOrgEmployeeConfigVO> queryListDynamic(PrdOrgEmployeeConfigQuery query) {
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = this.prdOrgEmployeeConfigDAO.queryListDynamic(query);
        if (PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(query.getConfigType())) {
            Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            if (!CollectionUtils.isEmpty(prdOrgEmployeeConfigVOS)) {
                PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
                prdSystemShortcutQuery.setShortcutStatus(Integer.valueOf(1));
                List prdSystemShortcutVOS = this.prdSystemShortcutService.queryListDynamic(prdSystemShortcutQuery);
                prdOrgEmployeeConfigVOS.stream().filter(vo -> PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(vo.getConfigType()) && StringUtils.hasText((String)vo.getContentJson())).forEach(vo -> {
                    List prdSystemShortcutJsonVOS = JSON.parseArray((String)vo.getContentJson(), PrdSystemShortcutJsonVO.class);
                    prdSystemShortcutJsonVOS = prdSystemShortcutJsonVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.SETTING.getCode())).collect(Collectors.toList());
                    if (!rolePermission.booleanValue()) {
                        prdSystemShortcutJsonVOS = prdSystemShortcutJsonVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).collect(Collectors.toList());
                    }
                    PrdSystemShortcutVO moreFunctionShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).findFirst().orElse(null);
                    List newShortcutVO = null;
                    newShortcutVO = rolePermission != false ? prdSystemShortcutVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).collect(Collectors.toList()) : prdSystemShortcutVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode()) && !item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).collect(Collectors.toList());
                    int index = newShortcutVO.size();
                    Map<String, List<PrdSystemShortcutJsonVO>> iconMap = prdSystemShortcutJsonVOS.stream().collect(Collectors.groupingBy(PrdSystemShortcutJsonVO::getType));
                    for (int i = 0; i < index; ++i) {
                        if (iconMap.containsKey(((PrdSystemShortcutVO)newShortcutVO.get(i)).getType())) continue;
                        PrdSystemShortcutVO vo1 = (PrdSystemShortcutVO)newShortcutVO.get(i);
                        PrdSystemShortcutJsonVO functionVO = new PrdSystemShortcutJsonVO();
                        functionVO.setType(vo1.getType());
                        functionVO.setFixFlag(vo1.getFixFlag());
                        functionVO.setIcon("/cloudt/system/com/file/v1/" + vo1.getShortcutIcon() + "/show");
                        functionVO.setTitle(vo1.getShortcutName());
                        functionVO.setBadge("");
                        functionVO.setShowBadgeFlag(Boolean.valueOf(false));
                        functionVO.setExt1("");
                        functionVO.setExt2("");
                        functionVO.setExt3("");
                        prdSystemShortcutJsonVOS.add(functionVO);
                    }
                    Map<String, List<PrdSystemShortcutVO>> newShortcutVOMap = newShortcutVO.stream().collect(Collectors.groupingBy(PrdSystemShortcutVO::getType));
                    ArrayList deleteList = new ArrayList();
                    prdSystemShortcutJsonVOS.stream().forEach(item -> {
                        if (!newShortcutVOMap.containsKey(item.getType())) {
                            deleteList.add(item);
                        }
                    });
                    if (!CollectionUtils.isEmpty(deleteList)) {
                        prdSystemShortcutJsonVOS.removeAll(deleteList);
                    }
                    if (moreFunctionShortcutVO != null && newShortcutVOMap.containsKey(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())) {
                        PrdSystemShortcutJsonVO moreFunctionVO = new PrdSystemShortcutJsonVO();
                        moreFunctionVO.setType(moreFunctionShortcutVO.getType());
                        moreFunctionVO.setFixFlag(moreFunctionShortcutVO.getFixFlag());
                        moreFunctionVO.setIcon("/cloudt/system/com/file/v1/" + moreFunctionShortcutVO.getShortcutIcon() + "/show");
                        moreFunctionVO.setTitle(moreFunctionShortcutVO.getShortcutName());
                        moreFunctionVO.setBadge("");
                        moreFunctionVO.setShowBadgeFlag(Boolean.valueOf(false));
                        moreFunctionVO.setExt1("");
                        moreFunctionVO.setExt2("");
                        moreFunctionVO.setExt3("");
                        prdSystemShortcutJsonVOS.add(moreFunctionShortcutVO.getSortIndex() - 1, moreFunctionVO);
                    }
                    vo.setContentJson(JSON.toJSONString(prdSystemShortcutJsonVOS));
                });
            }
            return prdOrgEmployeeConfigVOS;
        }
        return prdOrgEmployeeConfigVOS;
    }

    public PrdOrgEmployeeConfigVO queryByKey(Long key) {
        PrdOrgEmployeeConfigDO entity = this.prdOrgEmployeeConfigRepo.findById(key).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdOrgEmployeeConfigVO vo = PrdOrgEmployeeConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdOrgEmployeeConfigVO insert(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entityDo = PrdOrgEmployeeConfigConvert.INSTANCE.toDo(payload);
        return PrdOrgEmployeeConfigConvert.INSTANCE.toVo((PrdOrgEmployeeConfigDO)this.prdOrgEmployeeConfigRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdOrgEmployeeConfigVO update(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entity = this.prdOrgEmployeeConfigRepo.findById(payload.getId()).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdOrgEmployeeConfigDO entityDo = PrdOrgEmployeeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdOrgEmployeeConfigConvert.INSTANCE.toVo((PrdOrgEmployeeConfigDO)this.prdOrgEmployeeConfigRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entity = this.prdOrgEmployeeConfigRepo.findById(payload.getId()).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdOrgEmployeeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdOrgEmployeeConfigDAO.deleteSoft(keys);
        }
    }

    public PrdOrgEmployeeConfigServiceImpl(PrdOrgEmployeeConfigRepo prdOrgEmployeeConfigRepo, PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO, CacheUtil cacheUtil, PrdSystemShortcutService prdSystemShortcutService) {
        this.prdOrgEmployeeConfigRepo = prdOrgEmployeeConfigRepo;
        this.prdOrgEmployeeConfigDAO = prdOrgEmployeeConfigDAO;
        this.cacheUtil = cacheUtil;
        this.prdSystemShortcutService = prdSystemShortcutService;
    }
}

