/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u5458\u5de5\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/org"})
public class PrdOrgEmployeeController {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeController.class);
    private final PrdOrgEmployeeService service;
    private final PersonResService resService;

    @PostMapping(value={"/employee/saveTenantUser"})
    public TwOutputUtil saveTenantUser(PrdOrgTenantEmployeePayload entity) {
        return TwOutputUtil.ok(this.service.saveTenantUser(entity));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/employee/insert"})
    public TwOutputUtil insert(@RequestBody PrdOrgEmployeePayload entity) {
        return TwOutputUtil.ok(this.service.insert(entity));
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/employee/update"})
    public TwOutputUtil update(@RequestBody PrdOrgEmployeePayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u5458\u5de5\u7ec4\u7ec7\u5173\u7cfb")
    @PutMapping(value={"/employee/updateEmployeeRef"})
    public TwOutputUtil updateEmployeeRef(String payloadStrs) {
        this.service.updateEmployeeRef(JSONObject.parseArray((String)payloadStrs, PrdOrgEmployeeRefPayload.class));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @UdcNameClass
    @GetMapping(value={"/employee/list"})
    public TwOutputUtil queryList(PrdOrgEmployeeQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/employee/pading"})
    public TwOutputUtil queryPading(PrdOrgEmployeeQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @UdcNameClass
    @GetMapping(value={"/employee/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdOrgEmployeeVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u7528\u6237id\u67e5\u8be2")
    @GetMapping(value={"/employee/byUserId/{userId}"})
    public TwOutputUtil findByUserId(@PathVariable Long userId) {
        PrdOrgEmployeeVO vo = this.service.queryByUserId(userId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6240\u6709\u4e0a\u7ea7id")
    @GetMapping(value={"/employee/queryParentIds/{key}"})
    public TwOutputUtil queryParentIds(@PathVariable Long key) {
        return TwOutputUtil.ok(this.service.queryParentIdsByUserId(key));
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/employee/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u79fb\u9664\u5458\u5de5\u7ec4\u7ec7")
    @PutMapping(value={"/employee/deleteOrg"})
    public TwOutputUtil deleteOrg(Long userId, Long[] orgIds) {
        this.service.deleteOrgRefSoft(userId, Arrays.asList(orgIds));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @GetMapping(value={"/employee/resetEmployeePawword/{userId}"})
    public TwOutputUtil resetEmployeePawword(@PathVariable Long userId) {
        this.service.resetEmployeePawword(userId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/employee/getUserUUid"})
    public TwOutputUtil getUserUUid() {
        return TwOutputUtil.ok(this.service.getUserUUid());
    }

    @GetMapping(value={"/employee/bindWecomId"})
    public TwOutputUtil bindWecomId(String uuid) {
        return TwOutputUtil.ok(this.service.bindWecomId(uuid));
    }

    @GetMapping(value={"/employee/updateWecomId"})
    public TwOutputUtil updateWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        this.service.updateWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/employee/unbindWecomId"})
    public TwOutputUtil unbindWecomId(Long[] userId) {
        List<Long> userIdsData = null;
        if (userId != null && userId.length > 0) {
            userIdsData = Arrays.asList(userId);
        }
        this.service.unbindWecomId(userIdsData);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/employee/wxLogin/{code}"})
    public ApiResult<OAuthToken> wxLogin(@PathVariable String code) {
        ApiResult result = this.service.wxLogin(code);
        return result;
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/employee/batchExport"})
    public void batchExport(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        this.service.downloadPlus(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/employee/batchImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImport(MultipartFile file) {
        this.service.importEmployees(file);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u89d2\u8272")
    @GetMapping(value={"/employee/queryUserRole"})
    public TwOutputUtil queryUserRole(Long userId) {
        List roleCodes = this.service.queryUserRole(userId);
        return TwOutputUtil.ok(roleCodes);
    }

    @ApiOperation(value="\u8d44\u6e90\u65b0\u589e")
    @PostMapping(value={"/res/insert"})
    public TwOutputUtil insertRes(@RequestBody PrdOrgEmployeePayload entity) {
        this.service.insertNew(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u8d44\u6e90\u4fee\u6539")
    @PostMapping(value={"/res/update"})
    public TwOutputUtil update(@RequestBody PersonResPayload entity) {
        this.service.updateNew(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u53d8\u66f4-\u63d0\u4ea4")
    @PostMapping(value={"/res/personInfoChange/submit"})
    public TwOutputUtil submitPersonInfoChange(@RequestBody PersonResPayload entity) {
        this.resService.personInfoChangeSubmit(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u53d8\u66f4-\u7f16\u8f91")
    @PostMapping(value={"/res/personInfoChange/update"})
    public TwOutputUtil personalUpdate(@RequestBody PersonResPayload entity) {
        this.resService.updateChange(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u53d8\u66f4\u5bf9\u6bd4")
    @GetMapping(value={"/res/update/personal/query"})
    public TwOutputUtil personalChangeInfo(Long employeeId, String procId) {
        return TwOutputUtil.ok(this.resService.personalChangeInfo(employeeId, procId));
    }

    @ApiOperation(value="\u5165\u804c\u4fe1\u606f\u5b8c\u5584\u68c0\u67e5")
    @GetMapping(value={"/res/entry/check/{personId}"})
    public TwOutputUtil entryInfoCheck(@PathVariable Long personId) {
        return TwOutputUtil.ok(this.service.entryInfoCheck(personId));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u8ddf\u89d2\u8272\u4e00\u4e00\u5bf9\u5e94")
    @GetMapping(value={"/employee/pagingRole"})
    public TwOutputUtil queryPagingRoleO(PrdOrgEmployeeQuery query) {
        return TwOutputUtil.ok(this.service.pagingRole(query));
    }

    @ApiOperation(value="\u901a\u8fc7\u7ef4\u5ea6id\u67e5\u8be2\u7ef4\u5ea6\u4e0b\u7528\u6237\u6240\u6709\u76f4\u5c5e\u4e0a\u7ea7\u6570\u636e")
    @GetMapping(value={"/employee/queryParentUsers"})
    public TwOutputUtil queryParentUsers(Long dimensionId, Long userId) {
        return TwOutputUtil.ok(this.service.queryParentUsers(dimensionId, userId));
    }

    @ApiOperation(value="\u901a\u8fc7\u503cid\u67e5\u8be2\u7ef4\u5ea6\u4e0b\u7528\u6237\u6240\u6709\u76f4\u5c5e\u4e0b\u7ea7\u6570\u636e")
    @GetMapping(value={"/employee/queryLowListByKey"})
    public TwOutputUtil queryLowListByKey(Long orgId, Long userId) {
        return TwOutputUtil.ok(this.service.queryLowListByKey(orgId, userId));
    }

    @ApiOperation(value="\u901a\u8fc7\u503cid\u67e5\u8be2\u7ef4\u5ea6\u4e0b\u7528\u6237\u6240\u6709\u6240\u6709\u4e0b\u7ea7\uff08\u4e0b\u7ea7\u7684\u4e0b\u7ea7\u3002\u3002\u3002\uff09\u6570\u636e")
    @GetMapping(value={"/employee/queryLowChildListByKey"})
    public TwOutputUtil queryLowChildListByKey(Long orgId, Long userId) {
        return TwOutputUtil.ok(this.service.queryLowChildListByKey(orgId, userId));
    }

    @ApiOperation(value="\u901a\u8fc7\u503cid\u67e5\u8be2\u7ef4\u5ea6\u4e0b\u7528\u6237\u6240\u6709\u6240\u6709\u4e0a\u7ea7\uff08\u4e0a\u7ea7\u7684\u4e0a\u7ea7\u3002\u3002\u3002\uff09\u6570\u636e")
    @GetMapping(value={"/employee/queryAllParentUsers"})
    public TwOutputUtil queryAllParentUsers(Long dimensionId, Long userId) {
        return TwOutputUtil.ok(this.service.queryAllParentUsers(dimensionId, userId));
    }

    public PrdOrgEmployeeController(PrdOrgEmployeeService service, PersonResService resService) {
        this.service = service;
        this.resService = resService;
    }
}

