/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessParnerTaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerChangePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.CommonKeysPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessConfirmedCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerChangeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerDTO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerExportVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerIdentityVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerIndividualExportVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerListInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerTaskVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerTranslateVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerTreeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/crm/businessPartner"})
public class BusinessPartnerController {
    private static final Logger log = LoggerFactory.getLogger(BusinessPartnerController.class);
    private final BusinessPartnerService businessPartnerService;
    private final UdcUtil udcUtil;

    @PostMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4fdd\u5b58")
    public TwOutputUtil save(@RequestBody BusinessPartnerPayload payload) {
        if (payload.getId() != null) {
            this.businessPartnerService.insertOtherIdentity(payload, Boolean.valueOf(true));
        } else {
            this.businessPartnerService.insert(payload);
        }
        return TwOutputUtil.ok();
    }

    @PutMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u66f4\u65b0")
    public TwOutputUtil<BusinessPartnerVO> update(@RequestBody BusinessPartnerPayload payload) {
        return TwOutputUtil.ok(this.businessPartnerService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BusinessPartnerVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.businessPartnerService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5206\u9875")
    public TwOutputUtil<PagingVO<BusinessPartnerVO>> paging(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(this.businessPartnerService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BusinessPartnerVO>> queryList(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(this.businessPartnerService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.businessPartnerService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/listSimple"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u67e5\u8be2\u6bcd\u516c\u53f8\u4e0b\u62c9\u5217\u8868")
    public TwOutputUtil<List<BusinessPartnerSimpleVO>> queryListSimple() {
        return TwOutputUtil.ok(this.businessPartnerService.queryListSimple());
    }

    @GetMapping(value={"/judgePartnerName"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u4e1a\u52a1\u4f19\u4f34\u540d\u79f0\u91cd\u590d\u6027\u6821\u9a8c")
    public TwOutputUtil judgePartnerName(BusinessPartnerQuery query) {
        this.businessPartnerService.judgePartnerName(query.getPartnerName());
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/excelExport"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5bfc\u51fa")
    public void excelExport(BusinessPartnerQuery query, HttpServletResponse response) throws IOException {
        List vos = query.getIds() != null && query.getIds().size() > 0 ? this.businessPartnerService.queryListByIds(query.getIds()) : this.businessPartnerService.queryListDynamic(query);
        vos = this.udcUtil.translateList(vos);
        if (BusinessPartnerTypeEnum.ORGANIZATION.getCode().equals(query.getPartnerType())) {
            this.exportCompany(vos, response);
        }
        if (BusinessPartnerTypeEnum.INDIVIDUAL.getCode().equals(query.getPartnerType())) {
            this.exportIndividual(vos, response);
        }
    }

    public void exportCompany(List<BusinessPartnerVO> vos, HttpServletResponse response) throws IOException {
        List<BusinessPartnerExportVO> resultList = BusinessPartnerConvert.INSTANCE.voListVoExcelExport(vos);
        String sheetName = "\u4e1a\u52a1\u4f19\u4f34";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), BusinessPartnerExportVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, BusinessPartnerExportVO.class, null);
        sheet.doWrite(resultList);
    }

    public void exportIndividual(List<BusinessPartnerVO> vos, HttpServletResponse response) throws IOException {
        List<BusinessPartnerIndividualExportVO> resultList = BusinessPartnerConvert.INSTANCE.voListVoIndividualExcelExport(vos);
        String sheetName = "\u4e1a\u52a1\u4f19\u4f34";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), BusinessPartnerIndividualExportVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, BusinessPartnerIndividualExportVO.class, null);
        sheet.doWrite(resultList);
    }

    @GetMapping(value={"/judgeIdentityDisplay"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5224\u65ad\u8eab\u4efd\u90e8\u5206\u6807\u7b7e\u662f\u5426\u5c55\u793a")
    public TwOutputUtil<BusinessPartnerIdentityVO> judgeIdentityDisplay(@RequestParam(name="partnerId") String partnerId) {
        return TwOutputUtil.ok(this.businessPartnerService.judgeIdentityDisplay(Long.valueOf(partnerId)));
    }

    @GetMapping(value={"/listTree"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u7ec4\u7ec7\u6811")
    public TwOutputUtil<List<BusinessPartnerTreeVO>> listTree(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(this.businessPartnerService.listTree(query));
    }

    @GetMapping(value={"/queryBusinessPartnerInfoByPartnerName"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u901a\u8fc7\u540d\u5b57\u67e5\u8be2\u67e5\u8be2\u5168\u90e8\u8be6\u60c5")
    public TwOutputUtil<List<BusinessPartnerInfoVO>> queryBusinessPartnerInfoByPartnerName(String partnerName) {
        return TwOutputUtil.ok(this.businessPartnerService.queryBusinessPartnerInfoByPartnerName(partnerName));
    }

    @GetMapping(value={"/test"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u6d4b\u8bd5")
    public TwOutputUtil<BusinessPartnerDTO> test() {
        BusinessPartnerDTO businessPartnerDTO = new BusinessPartnerDTO();
        BusinessPartnerTranslateVO businessPartnerTranslateVO = new BusinessPartnerTranslateVO();
        BookAddressVO bookAddressVO = new BookAddressVO();
        BookContactsVO bookContactsVO = new BookContactsVO();
        BookInvoiceVO bookInvoiceVO = new BookInvoiceVO();
        BookAccountVO bookAccountVO = new BookAccountVO();
        BusinessCustomerInfoVO businessCustomerInfoVO = new BusinessCustomerInfoVO();
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = new BusinessCollaboratePartnerInfoVO();
        BusinessSupplierInfoVO businessSupplierInfoVO = new BusinessSupplierInfoVO();
        businessPartnerDTO.setBusinessPartnerVO(businessPartnerTranslateVO);
        businessPartnerDTO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
        businessPartnerDTO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
        businessPartnerDTO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
        businessPartnerDTO.setBookAccountVOList(Collections.singletonList(bookAccountVO));
        businessPartnerDTO.setBookAddressVOList(Collections.singletonList(bookAddressVO));
        businessPartnerDTO.setBookInvoiceVOList(Collections.singletonList(bookInvoiceVO));
        businessPartnerDTO.setBookContactsVOList(Collections.singletonList(bookContactsVO));
        return TwOutputUtil.ok(businessPartnerDTO);
    }

    @PostMapping(value={"/changeAccountAndInvoice"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u94f6\u884c\u8d26\u6237/\u5f00\u7968\u4fe1\u606f\u53d8\u66f4")
    public TwOutputUtil changeAccountAndInvoice(@RequestBody BusinessPartnerChangePayload payload) {
        this.businessPartnerService.changeAccountAndInvoice(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/changeAccountAndInvoiceUpdate"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u94f6\u884c\u8d26\u6237/\u5f00\u7968\u4fe1\u606f\u53d8\u66f4\u66f4\u65b0")
    public TwOutputUtil changeAccountAndInvoiceUpdate(@RequestBody BusinessPartnerChangePayload payload) {
        this.businessPartnerService.changeAccountAndInvoiceUpdate(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryChangeAccountAndInvoiceInfo"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u94f6\u884c\u8d26\u6237/\u5f00\u7968\u4fe1\u606f\u53d8\u66f4\u8be6\u60c5\u67e5\u8be2")
    public TwOutputUtil<BusinessPartnerChangeVO> queryChangeAccountAndInvoiceInfo(Long businessKey, Long partnerId) {
        return TwOutputUtil.ok(this.businessPartnerService.queryChangeAccountAndInvoiceInfo(businessKey, partnerId));
    }

    @PostMapping(value={"/businessPartnerTaskInfo"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34\u7ba1\u7406-\u5de5\u4f5c\u6d41\u4efb\u52a1\u8be6\u60c5\u67e5\u8be2")
    public TwOutputUtil<BusinessPartnerTaskVO> businessPartnerTaskInfo(@RequestBody BusinessParnerTaskInfoPayload payload) {
        return TwOutputUtil.ok(this.businessPartnerService.businessPartnerTaskInfo(payload));
    }

    @GetMapping(value={"/queryConfirmedCustomer"})
    @ApiOperation(value="\u5ba2\u6237\u7ba1\u7406-\u5f85\u786e\u8ba4\u6f5c\u5728\u5ba2\u6237\u67e5\u8be2")
    @UdcNameClass
    public TwOutputUtil<PagingVO<BusinessConfirmedCustomerVO>> queryConfirmedCustomer(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(this.businessPartnerService.queryConfirmedCustomer(query));
    }

    @PostMapping(value={"/updateConfirmedCustomer"})
    @ApiOperation(value="\u5ba2\u6237\u7ba1\u7406-\u5f85\u786e\u8ba4\u6f5c\u5728\u5ba2\u6237\u66f4\u65b0")
    public TwOutputUtil updateConfirmedCustomer(@RequestBody CommonKeysPayload payload) {
        this.businessPartnerService.updateConfirmedCustomer(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryCustomerByBookId"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u6839\u636ebookId\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    public TwOutputUtil<BusinessPartnerVO> queryCustomerByBookId(Long bookId) {
        return TwOutputUtil.ok(this.businessPartnerService.queryCustomerByBookId(bookId));
    }

    @PostMapping(value={"/updateAccAndInvoice"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u6fc0\u6d3b\u4fee\u6539\u94f6\u884c\u4fe1\u606f/\u5f00\u7968\u4fe1\u606f\u6570\u636e")
    public TwOutputUtil updateAccAndInvoice(@RequestBody BusinessPartnerChangeVO vo) {
        this.businessPartnerService.updateAccAndInvoice(vo);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/updateAccAndInvoice2"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u5ba2\u6237\u6fc0\u6d3b\u4fee\u6539\u94f6\u884c\u4fe1\u606f/\u5f00\u7968\u4fe1\u606f\u6570\u636e")
    public TwOutputUtil updateAccAndInvoice2(@RequestBody BusinessPartnerChangeVO vo) {
        this.businessPartnerService.updateAccAndInvoice2(vo);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/checkExitInvices"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u6839\u636eBookId\u6821\u9a8c\u8be5\u5ba2\u6237\u662f\u5426\u6709\u5f00\u7968\u4fe1\u606f\u6216\u6b63\u5728\u6d41\u8f6c\u7684\u5ba2\u6237\u6fc0\u6d3b\u6d41\u7a0b\u6216\u5ba2\u6237\u53d8\u66f4\u6d41\u7a0b")
    public TwOutputUtil<Boolean> checkExitInvices(Long custId) {
        return TwOutputUtil.ok(this.businessPartnerService.checkExitInvices(custId));
    }

    @GetMapping(value={"/findListInfoByBookIds"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u6839\u636eBookId\u8fd4\u56de\u4fe1\u606f")
    public TwOutputUtil<List<BusinessPartnerListInfoVO>> findListInfoByBookIds(@RequestParam(value="bookIdList") List<Long> bookIdList) {
        return TwOutputUtil.ok(this.businessPartnerService.findListInfoByBookIds(bookIdList));
    }

    public BusinessPartnerController(BusinessPartnerService businessPartnerService, UdcUtil udcUtil) {
        this.businessPartnerService = businessPartnerService;
        this.udcUtil = udcUtil;
    }
}

