/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanSavePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ContractNodeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6536\u6b3e\u8ba1\u5212"})
@RestController
@RequestMapping(value={"/api/contract/receivablePlan"})
public class ConReceivablePlanController {
    private static final Logger log = LoggerFactory.getLogger(ConReceivablePlanController.class);
    private final ConReceivablePlanService conReceivablePlanService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody ConReceivablePlanPayload payload) {
        return TwOutputUtil.ok(this.conReceivablePlanService.insert(payload));
    }

    @PatchMapping(value={"/saveRecvPlans"})
    @ApiOperation(value="\u4fdd\u5b58\u591a\u6761\u8bb0\u5f55")
    public TwOutputUtil saveRecvPlans(@RequestBody ConReceivablePlanSavePayload payload) {
        return TwOutputUtil.ok(this.conReceivablePlanService.saveContractRecvPlans(payload));
    }

    @PutMapping(value={"/updateExpectReceDate"})
    @ApiOperation(value="\u66f4\u65b0\u9884\u8ba1\u6536\u6b3e\u65e5\u671f")
    public TwOutputUtil updateExpectReceDate(@RequestBody Map<Long, String> updateData) {
        this.conReceivablePlanService.updateExpectReceDate(updateData);
        return TwOutputUtil.ok();
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody ConReceivablePlanPayload payload) {
        return TwOutputUtil.ok(this.conReceivablePlanService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.conReceivablePlanService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(this.conReceivablePlanService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(this.conReceivablePlanService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.conReceivablePlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/plan/{saleConId}"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u5408\u540cID\u67e5\u8be2")
    public TwOutputUtil queryBySaleConId(@PathVariable Long saleConId, ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(this.conReceivablePlanService.queryBySaleConId(saleConId, query));
    }

    @ApiOperation(value="\u6536\u6b3e\u5217\u8868\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/plan/batchReceivablePlanExport"})
    public void batchReceivablePlanExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        this.conReceivablePlanService.batchReceivablePlanExport(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/plan/batchExport"})
    public void batchExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        this.conReceivablePlanService.downloadBatch(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/plan/batchImportPro"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImportPro(MultipartFile file, Boolean force, Long saleConId) throws InterruptedException {
        Map resultMap = this.conReceivablePlanService.importBatchPro(file, force, saleConId);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok();
        }
        if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        }
        return TwOutputUtil.error("", "", resultMap);
    }

    @PatchMapping(value={"/invalid"})
    public TwOutputUtil invalidRecvplan(@RequestParam Long[] ids, @RequestParam String remark) {
        this.conReceivablePlanService.invalidRecvplan(Arrays.asList(ids), remark);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/updateRecvOrInvDate"})
    public TwOutputUtil updateRecvOrInvDate(@RequestBody ConRecvplanChangeLogPayload payload) {
        Boolean flag = this.conReceivablePlanService.updateRecvOrInvDate(payload);
        if (flag.booleanValue()) {
            return TwOutputUtil.ok();
        }
        return TwOutputUtil.error("", "\u64cd\u4f5c\u5931\u8d25", null);
    }

    @GetMapping(value={"/findConNodeByConId"})
    @UdcNameClass
    public TwOutputUtil<List<ContractNodeVO>> findConNodeByConId(Long saleConId) {
        return TwOutputUtil.ok(this.conReceivablePlanService.findConNodeByConId(saleConId));
    }

    @GetMapping(value={"/queryAppMyHandlNum"})
    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u6536\u6b3e\u548c\u5f00\u7968\u6570\u91cf")
    public TwOutputUtil queryAppMyHandlNum(String type) {
        return TwOutputUtil.ok(this.conReceivablePlanService.queryAppMyHandlNum(type));
    }

    public ConReceivablePlanController(ConReceivablePlanService conReceivablePlanService) {
        this.conReceivablePlanService = conReceivablePlanService;
    }
}

