/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinPeriodService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinYearService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFinPeriodConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFinPeriodDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinPeriodRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdSystemFinPeriodServiceImpl
extends BaseServiceImpl
implements PrdSystemFinPeriodService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFinPeriodServiceImpl.class);
    private final PrdSystemFinPeriodRepo prdSystemFinPeriodRepo;
    private final PrdSystemFinPeriodDAO prdSystemFinPeriodDAO;
    private final PrdSystemFinYearService prdSystemFinYearService;

    public PagingVO<PrdSystemFinPeriodVO> queryPaging(PrdSystemFinPeriodQuery query) {
        return this.prdSystemFinPeriodDAO.queryPaging(query);
    }

    public List<PrdSystemFinPeriodVO> queryListDynamic(PrdSystemFinPeriodQuery query) {
        return this.prdSystemFinPeriodDAO.queryListDynamic(query);
    }

    public PrdSystemFinPeriodVO queryByKey(Long key) {
        return this.prdSystemFinPeriodDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemFinPeriodVO insert(PrdSystemFinPeriodPayload payload) {
        PrdSystemFinPeriodVO vo = this.prdSystemFinPeriodDAO.selectInspect(payload.getPeriodName());
        if (vo != null) {
            throw TwException.error("", "\u8d22\u52a1\u671f\u95f4\u5df2\u5b58\u5728\uff01");
        }
        PrdSystemFinPeriodDO entityDo = PrdSystemFinPeriodConvert.INSTANCE.toDo(payload);
        PrdSystemFinYearVO prdSystemFinYearVO = this.prdSystemFinYearService.findByFinYear(payload.getFinYear());
        entityDo.setFinYearId(prdSystemFinYearVO.getId());
        return PrdSystemFinPeriodConvert.INSTANCE.toVo((PrdSystemFinPeriodDO)this.prdSystemFinPeriodRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemFinPeriodVO update(PrdSystemFinPeriodPayload payload) {
        PrdSystemFinPeriodDO entity = this.prdSystemFinPeriodRepo.findById(payload.getId()).orElseGet(PrdSystemFinPeriodDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemFinPeriodVO vo = this.prdSystemFinPeriodDAO.selectInspect(payload.getPeriodName());
        if (vo != null && !vo.getId().equals(payload.getId())) {
            throw TwException.error("", "\u8d22\u52a1\u671f\u95f4\u5df2\u5b58\u5728\uff01");
        }
        PrdSystemFinPeriodDO entityDo = PrdSystemFinPeriodConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdSystemFinYearVO prdSystemFinYearVO = this.prdSystemFinYearService.findByFinYear(payload.getFinYear());
        entity.setFinYearId(prdSystemFinYearVO.getId());
        return PrdSystemFinPeriodConvert.INSTANCE.toVo((PrdSystemFinPeriodDO)this.prdSystemFinPeriodRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdSystemFinPeriodDAO.deleteSoft(keys);
        }
    }

    public PrdSystemFinPeriodServiceImpl(PrdSystemFinPeriodRepo prdSystemFinPeriodRepo, PrdSystemFinPeriodDAO prdSystemFinPeriodDAO, PrdSystemFinYearService prdSystemFinYearService) {
        this.prdSystemFinPeriodRepo = prdSystemFinPeriodRepo;
        this.prdSystemFinPeriodDAO = prdSystemFinPeriodDAO;
        this.prdSystemFinYearService = prdSystemFinYearService;
    }
}

