/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PA_{procDefKey}/callBack"})
@Transactional
public class PurchaseAgreementCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementCallBackController.class);
    private final PurchaseAgreementService service;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PurchaseAgreementPayload purchaseAgreementPayload = new PurchaseAgreementPayload();
        purchaseAgreementPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        PurchaseAgreementVO purchaseAgreementVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (purchaseAgreementVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    purchaseAgreementPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchaseAgreementPayload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    purchaseAgreementPayload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.CREATE.getCode());
                    purchaseAgreementPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    this.service.deleteSoft(Collections.singletonList(Long.parseLong(businessKey)));
                    purchaseAgreementPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    purchaseAgreementPayload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.APPROVING.getCode());
                    purchaseAgreementPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    purchaseAgreementPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchaseAgreementPayload.setApprovedTime(LocalDateTime.now());
                    purchaseAgreementPayload.setActivateDate(LocalDateTime.now());
                    purchaseAgreementPayload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode());
                    break;
                }
                case APPROVING: {
                    purchaseAgreementPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchaseAgreementPayload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.APPROVING.getCode());
                }
            }
            this.service.updateByKeyDynamic(purchaseAgreementPayload);
        }
        return WorkflowResult.success(null);
    }

    public PurchaseAgreementCallBackController(PurchaseAgreementService service) {
        this.service = service;
    }
}

