package com.elitesland.tw.tw5.server.common.change.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 通用变更信息表(com_business_change)实体类
 *
 * @author liwenpeng
 */

@Entity
@Table(name = "prd_system_business_change")
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "prd_system_business_change", comment = "通用变更信息表")
@Where(clause = "delete_flag= 0")
public class PrdSystemBusinessChangeDO extends BaseModel {

    @Column()
    @Comment("变更单据类型")
    private String changeType;

    @Column()
    @Comment("父级变更单据类型")
    private String parentChangeType;

    @Column()
    @Comment("变更单据id")
    private String changeDocId;

    @Column()
    @Comment("父级变更单据id")
    private String parentChangeDocId;

    @Column(name = "change_content", columnDefinition = "LONGTEXT")
    @Comment("变更信息")
    private String changeContent;

    @Column(name = "version_content", columnDefinition = "LONGTEXT")
    @Comment("当前版本信息")
    private String versionContent;

    @Column()
    @Comment("版本号")
    private Integer versionNo;

    @Column()
    @Comment("版本状态 1:已完成   0:草稿")
    private Integer versionStatus;

    @Column()
    @Comment("流程实例ID")
    private String procInstId;

}

