package com.elitesland.tw.tw5.server.common.dao;


import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.repo.TransferUtilRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class TransferUtilDAO {
    private final TransferUtilRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgEmployeeDO qPrdOrgEmployeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    /**
     * 获取Tw4员工数据
     *
     * @param userIds
     * @return
     */
    public List<Map<String, Long>> queryEmployeeTw4Maps(List<Long> userIds) {
        return repo.queryTw4Employees(userIds);
    }

    /**
     * 获取Tw5员工数据
     *
     * @param userIds
     * @return
     */
    public List<Map<String, Object>> queryEmployeeTw5Maps(List<Long> userIds) {
        return repo.queryTw5Employees(userIds);
    }

    /**
     * 获取Tw5员工数据 感觉上面那个写的不好 因为获取的时候每次都会循环list 这边直接查询list 然后转map
     *
     * @param userIds
     * @return
     */
    public List<PrdOrgEmployeeVO> queryTw4ByUserIdList(List<Long> userIds) {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                qPrdOrgEmployeeDO.userId,
                qPrdOrgEmployeeDO.userIdV4)).
                from(qPrdOrgEmployeeDO).
                where(qPrdOrgEmployeeDO.userId.in(userIds)).
                where(qPrdOrgEmployeeDO.deleteFlag.eq(0)).fetch();
    }
    /**
     * 查询tw4.0 用户ids
     *
     * @param userIds
     * @return
     */
    public List<Long> queryEmployeeTw4Ids(List<Long> userIds) {
        return repo.queryEmployeeTw4Ids(userIds);
    }

    /**
     * 获取组织数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Long>> queryOrgTw4Maps(List<Long> orgIds) {
        return repo.queryTw4Orgs(orgIds);
    }

    /**
     * 根据4.0组织主键 获取Tw5组织数据
     * 只change_id = 0的数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Long>> queryOrgTw5Maps(List<Long> orgIds) {
        return repo.queryTw5Orgs(orgIds);
    }

    /**
     * 获取Tw5组织员工关系数据
     *
     * @param refIds
     * @return
     */
    public List<Map<String, Long>> queryOrgRefUserTw5Maps(List<Long> refIds) {
        return repo.queryTw5OrgRefUsers(refIds);
    }

    /**
     * 获取地址簿数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Long>> queryBookTw4Maps(List<Long> orgIds) {
        return repo.queryTw4Books(orgIds);
    }

    /**
     * 获取地址簿数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Long>> queryOppoTw4Maps(List<Long> orgIds) {
        return repo.queryOppoTw4Maps(orgIds);
    }

    /**
     * 获取Tw5地址簿数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Long>> queryBookTw5Maps(List<Long> orgIds) {
        return repo.queryTw5Books(orgIds);
    }

    /**
     * 获取内部公司
     *
     * @return
     */
    public List<Map<String, Long>> queryInterCompanyTw5Maps(String bookType, String relateType) {
        return repo.queryInterCompanyTw5Maps(bookType, relateType);
    }
}
