package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

;

/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Entity
@Table(name = "acc_subject_template_detail", indexes = {
        @Index(name = "tmpl_index", columnList = "tmpl_id"),
        @Index(name = "business_index", columnList = "business_id"),
        @Index(name = "budget_index", columnList = "budget_id"),
        @Index(name = "acc_index", columnList = "acc_id")
})
@org.hibernate.annotations.Table(appliesTo = "acc_subject_template_detail", comment = "科目模板明细管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccSubjectTemplateDetailDO extends BaseModel implements Serializable {
    /**
     * 模板id
     */
    @Comment("模板id")
    @Column(name = "tmpl_id")
    private Long tmplId;
    /**
     * 核算项目id
     */
    @Comment("核算项目id")
    @Column(name = "business_id")
    private Long businessId;
    /**
     * 预算项目id
     */
    @Comment("预算项目id")
    @Column(name = "budget_id")
    private Long budgetId;
    /**
     * 会计科目id
     */
    @Comment("会计科目id")
    @Column(name = "acc_id")
    private Long accId;

    /**
     * 是否控制
     */
    @Comment("是否控制")
    @Column(columnDefinition = "tinyint NOT NULL DEFAULT 0")
    private Integer controlFlag;
    /**
     * 是否考核
     */
    @Comment("是否考核")
    @Column()
    private Boolean examineFlag;
    /**
     * 是否包含
     */
    @Comment("是否包含")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer includeFlag;
    /**
     * 处理状态
     */
    @Comment("处理状态")
    @Column()
    private String procStatus;
    /**
     * 处理信息
     */
    @Comment("处理信息")
    @Column()
    private String procInfo;
    /**
     * 处理时间
     */
    @Comment("处理时间")
    @Column()
    private LocalDateTime procTime;
    /**
     * 可配置字段1
     */
    @Comment("可配置字段1")
    @Column()
    private String extStr1;
    /**
     * 可配置字段2
     */
    @Comment("可配置字段2")
    @Column()
    private String extStr2;
    /**
     * 可配置字段3
     */
    @Comment("可配置字段3")
    @Column()
    private String extStr3;
    /**
     * 可配置字段4
     */
    @Comment("可配置字段4")
    @Column()
    private String extStr4;
    /**
     * 可配置字段5
     */
    @Comment("可配置字段5")
    @Column()
    private String extStr5;

    public void copy(AccSubjectTemplateDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
