package com.elitesland.tw.tw5.server.prd.adm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Entity
@Table(name = "adm_trip_ticket", indexes = {
        @Index(name = "apply_index", columnList = "apply_id"),
        @Index(name = "idx_reim_id", columnList = "reim_id")
})
@org.hibernate.annotations.Table(appliesTo = "adm_trip_ticket", comment = "行政订票管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AdmTripTicketDO extends BaseModel implements Serializable {
    /**
     * 申请id
     */
    @Comment("申请id")
    @Column(name = "apply_id")
    private Long applyId;
    /**
     * 订票费用类型
     */
    @Comment("订票费用类型")
    @Column()
    private String ticketExpType;
    /**
     * 出差人资源id
     */
    @Comment("出差人资源id")
    @Column()
    private Long tripResId;
    /**
     * 订票人资源id
     */
    @Comment("订票人资源id")
    @Column()
    private Long bookingResId;
    /**
     * 出发地
     */
    @Comment("出发地")
    @Column()
    private String fromPlace;
    /**
     * 目的地
     */
    @Comment("目的地")
    @Column()
    private String toPlace;
    /**
     * 交通工具
     */
    @Comment("交通工具")
    @Column()
    private String vehicle;
    /**
     * 出差日期
     */
    @Comment("出差日期")
    @Column()
    private LocalDate tripDate;
    /**
     * 时间段
     */
    @Comment("时间段")
    @Column()
    private String timespan;
    /**
     * 订票日期
     */
    @Comment("订票日期")
    @Column()
    private LocalDate bookingDate;
    /**
     * 车次航班
     */
    @Comment("车次航班")
    @Column()
    private String vehicleNo;
    /**
     * 金额
     */
    @Comment("金额")
    @Column()
    private BigDecimal expAmt;
    /**
     * 票务使用状态
     */
    @Comment("票务使用状态")
    @Column()
    private String useStatus;
    /**
     * 购票渠道
     */
    @Comment("购票渠道")
    @Column()
    private String ticketPurchasingChannel;
    /**
     * 报销状态
     */
    @Comment("报销状态")
    @Column()
    private String reimbursementStatus;

    @Comment("报销单ID")
    @Column(name = "reim_id")
    private Long reimId;

    public void copy(AdmTripTicketDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
