package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 预算科目明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Entity
@Table(name = "pms_budget_subject_detail", indexes = {
        @Index(name = "budget_index", columnList = "budget_id"),
        @Index(name = "acc_index", columnList = "acc_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_subject_detail", comment = "预算科目明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BudgetSubjectDetailDO extends BaseModel implements Serializable {
    /**
     * 预算ID
     */
    @Comment("预算ID")
    @Column(name = "budget_id")
    private Long budgetId;
    /**
     * 科目ID
     */
    @Comment("科目ID")
    @Column(name = "acc_id")
    private Long accId;
    /**
     * 科目父级ID
     */
    @Comment("科目父级ID")
    @Column()
    private Long accParentId;
    /**
     * 原始预算金额
     */
    @Comment("原始预算金额")
    @Column()
    private BigDecimal originalAmt;
    /**
     * 预算金额
     */
    @Comment("预算金额")
    @Column()
    private BigDecimal budgetAmt;
    /**
     * 已拨付金额
     */
    @Comment("已拨付金额")
    @Column()
    private BigDecimal feeReleasedAmt;
    /**
     * 已使用金额
     */
    @Comment("已使用金额")
    @Column()
    private BigDecimal usedAmt;
    /**
     * 可用金额
     */
    @Comment("可用金额")
    @Column()
    private BigDecimal availableAmt;
    /**
     * 占用金额
     */
    @Comment("占用金额")
    @Column()
    private BigDecimal occupyAmt;
    /**
     * 可配置化字段1
     */
    @Comment("可配置化字段1")
    @Column()
    private String configurableField1;
    /**
     * 可配置化字段2
     */
    @Comment("可配置化字段2")
    @Column()
    private String configurableField2;
    /**
     * 可配置化字段3
     */
    @Comment("可配置化字段3")
    @Column()
    private String configurableField3;
    /**
     * 明细控制
     */
    @Comment("明细控制 ")
    @Column()
    private Boolean detailControlFlag;

    @Comment("费用占比")
    @Column()
    private BigDecimal amtProportion;

    @Comment("使用当量占比")
    @Column()
    private BigDecimal usedEqvaProportion;

    @Comment("使用费用占比")
    @Column()
    private BigDecimal usedAmtProportion;

    public void copy(BudgetSubjectDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
