package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaCostPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaCostQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaCostService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaCostVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Api(tags = "当量成本配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calEqvaCost")
@Slf4j
public class CalEqvaCostController {

    private final CalEqvaCostService calEqvaCostService;

    /**
     * 当量成本配置管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("当量成本配置管理-新增或修改")
    public TwOutputUtil<CalEqvaCostVO> insertOrUpdate(@RequestBody CalEqvaCostPayload payload) {
        return TwOutputUtil.ok(calEqvaCostService.insertOrUpdate(payload));
    }

    /**
     * 当量成本配置管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("当量成本配置管理-主键查询")
    public TwOutputUtil<CalEqvaCostVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calEqvaCostService.queryByKey(key));
    }

    /**
     * 当量成本配置管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("当量成本配置管理-分页")
    public TwOutputUtil<PagingVO<CalEqvaCostVO>> paging(CalEqvaCostQuery query) {
        return TwOutputUtil.ok(calEqvaCostService.queryPaging(query));
    }

    /**
     * 当量成本配置管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("当量成本配置管理-查询列表")
    public TwOutputUtil<List<CalEqvaCostVO>> queryList(CalEqvaCostQuery query) {
        return TwOutputUtil.ok(calEqvaCostService.queryListDynamic(query));
    }

    /**
     * 当量成本配置管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("当量成本配置管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calEqvaCostService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

