package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleDetailQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleDetailService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleDetailVO;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalTaskSettleDetailConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalTaskSettleDetailDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalTaskSettleDetailDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalTaskSettleDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 任务包
 *
 * @author carl
 * @date 2023-11-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalTaskSettleDetailServiceImpl extends BaseServiceImpl implements CalTaskSettleDetailService {

    private final CalTaskSettleDetailRepo calTaskSettleDetailRepo;
    private final CalTaskSettleDetailDAO calTaskSettleDetailDAO;

    @Override
    public PagingVO<CalTaskSettleDetailVO> queryPaging(CalTaskSettleDetailQuery query) {
        return calTaskSettleDetailDAO.queryPaging(query);
    }

    @Override
    public List<CalTaskSettleDetailVO> queryListDynamic(CalTaskSettleDetailQuery query) {
        return calTaskSettleDetailDAO.queryListDynamic(query);
    }

    @Override
    public List<CalTaskSettleDetailVO> bacthInsert(List<CalTaskSettleDetailPayload> payloads) {
        List<CalTaskSettleDetailDO> dos = CalTaskSettleDetailConvert.INSTANCE.toDos(payloads);
        calTaskSettleDetailDAO.saveAll(dos);


        return null;
    }

    @Override
    public void deleteSoftBySettleId(List<Long> settleIds) {
        calTaskSettleDetailDAO.deleteSoftBySettleId(settleIds);
    }

    @Override
    public long updateByKeyDynamic(CalTaskSettleDetailPayload payload) {
        return calTaskSettleDetailDAO.updateByKeyDynamic(payload);
    }

    @Override
    public List<String> queryTaskSettleDetails(List<Long> taskIds, List<String> statuss) {
        return calTaskSettleDetailDAO.queryTaskSettleDetails(taskIds, statuss);
    }

}
