package com.elitesland.tw.tw5.server.prd.copartner.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
@Entity
@Table(name = "performance_readme_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "performance_readme_config", comment = "合伙人绩效自述配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PerformanceReadmeConfigDO extends BaseModel implements Serializable {
    /**
     * 名称
     */
    @Comment("名称")
    @Column()
    private String configName;
    /**
     * 考核周期
     */
    @Comment("考核周期")
    @Column()
    private String configCycle;
    /**
     * 开始日期
     */
    @Comment("开始日期")
    @Column()
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String configStatus;
    @Comment("发起人")
    @Column()
    private Long applyUserId;
    /**
     * 发起时间
     */
    @Comment("发起时间")
    @Column()
    private LocalDateTime applyTime;
    /**
     * 完成时间
     */
    @Comment("完成时间")
    @Column()
    private LocalDateTime finishTime;

    public void copy(PerformanceReadmeConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
