package com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBuChangeTodoDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.QPrdBuChangeTodoDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


 /**
 * @author : WWW
 * @date : 2023-11-7
 * @desc : baseBU变更待办事项RepoProc
 */
 
@Component
public class PrdBuChangeTodoDao extends BaseRepoProc<PrdBuChangeTodoDO>{
    
    private static final QPrdBuChangeTodoDO qPrdBuChangeTodoDO = QPrdBuChangeTodoDO.prdBuChangeTodoDO;
    
    
    protected PrdBuChangeTodoDao() {
    
        super(qPrdBuChangeTodoDO);
        
    }
    
    
    public PagingVO<PrdBuChangeTodoVO> page(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {
        
        JPAQuery<PrdBuChangeTodoVO> query = 
            select(PrdBuChangeTodoVO.class)
                .where(bulidPredicate(prdBuChangeTodoQuery));
        prdBuChangeTodoQuery.setPaging(query);
        prdBuChangeTodoQuery.fillOrders(query, qPrdBuChangeTodoDO);
        return PagingVO.<PrdBuChangeTodoVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
                
    }
    
    
    public Long del(List<Long> ids) {
        
        Long res = jpaQueryFactory.update(qPrdBuChangeTodoDO)
                .set(qPrdBuChangeTodoDO.deleteFlag, 1)
                .where(qPrdBuChangeTodoDO.id.in(ids))
                .execute();
        
        return res;
        
    }
    
    
    public PrdBuChangeTodoVO get(Long id) {
    
        PrdBuChangeTodoVO prdBuChangeTodoVO = select(PrdBuChangeTodoVO.class)
                .where(qPrdBuChangeTodoDO.id.eq(id))
                .fetchOne();
        if (null == prdBuChangeTodoVO) {
            throw new BusinessException("id不正确，未找到数据");
        }
        return prdBuChangeTodoVO;
        
    }
    
    
    public List<PrdBuChangeTodoVO> getList(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {
        
        List<PrdBuChangeTodoVO> res = 
            select(PrdBuChangeTodoVO.class)
                .where(bulidPredicate(prdBuChangeTodoQuery))
                .fetch();
        
        return res;
        
    }
    
    
    private <T> JPAQuery<T> select(Class<T> cls) {
    
        return 
                jpaQueryFactory.select(Projections.bean(cls,
                    qPrdBuChangeTodoDO.changeId,
                    qPrdBuChangeTodoDO.todoTitle,
                    qPrdBuChangeTodoDO.todoDesc,
                    qPrdBuChangeTodoDO.state,
                    qPrdBuChangeTodoDO.todoRemark,
                    qPrdBuChangeTodoDO.id,
                    qPrdBuChangeTodoDO.createTime,
                    qPrdBuChangeTodoDO.remark
                
                )).from(qPrdBuChangeTodoDO);
            
    }
    
    
    private Predicate bulidPredicate(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {
    
        Predicate predicate = PredicateBuilder.builder()
            .andEq(null != prdBuChangeTodoQuery.getChangeId(), qPrdBuChangeTodoDO.changeId, prdBuChangeTodoQuery.getChangeId())
            .andEq(null != prdBuChangeTodoQuery.getTodoTitle(), qPrdBuChangeTodoDO.todoTitle, prdBuChangeTodoQuery.getTodoTitle())
            .andEq(null != prdBuChangeTodoQuery.getTodoDesc(), qPrdBuChangeTodoDO.todoDesc, prdBuChangeTodoQuery.getTodoDesc())
            .andEq(null != prdBuChangeTodoQuery.getState(), qPrdBuChangeTodoDO.state, prdBuChangeTodoQuery.getState())
            .andEq(StringUtils.isNotBlank(prdBuChangeTodoQuery.getTodoRemark()), qPrdBuChangeTodoDO.todoRemark, prdBuChangeTodoQuery.getTodoRemark())
            .build();
            
        return predicate;
        
    }
    
    
    private List<Predicate> bulidPredicates(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {
        
        List<Predicate> predicates = new ArrayList<>();
        // 变更主键
        if (null != prdBuChangeTodoQuery.getChangeId()) {
            predicates.add(qPrdBuChangeTodoDO.changeId.eq(prdBuChangeTodoQuery.getChangeId()));
        }
        // 检查事项
        if (null != prdBuChangeTodoQuery.getTodoTitle()) {
            predicates.add(qPrdBuChangeTodoDO.todoTitle.eq(prdBuChangeTodoQuery.getTodoTitle()));
        }
        // 检查说明
        if (null != prdBuChangeTodoQuery.getTodoDesc()) {
            predicates.add(qPrdBuChangeTodoDO.todoDesc.eq(prdBuChangeTodoQuery.getTodoDesc()));
        }
        // 状态
        if (null != prdBuChangeTodoQuery.getState()) {
            predicates.add(qPrdBuChangeTodoDO.state.eq(prdBuChangeTodoQuery.getState()));
        }
        // 备注
        if (StringUtils.isNotEmpty(prdBuChangeTodoQuery.getTodoRemark())) {
            predicates.add(qPrdBuChangeTodoDO.todoRemark.eq(prdBuChangeTodoQuery.getTodoRemark()));
        }
        
//      Predicate predicate = ExpressionUtils.allOf(predicates);
        
        return predicates;
    }
    
    
    public Long count(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {
    
        long res = select(PrdBuChangeTodoVO.class)
                .where(bulidPredicate(prdBuChangeTodoQuery))
                .fetchCount();
        
        return res;
        
        
    }
    
    public Long update(PrdBuChangeTodoPayload prdBuChangeTodoPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdBuChangeTodoDO);
        
        // 变更主键
        if (null != prdBuChangeTodoPayload.getChangeId()) {
            update.set(qPrdBuChangeTodoDO.changeId,prdBuChangeTodoPayload.getChangeId());
        }
        // 检查事项
        if (null != prdBuChangeTodoPayload.getTodoTitle()) {
            update.set(qPrdBuChangeTodoDO.todoTitle,prdBuChangeTodoPayload.getTodoTitle());
        }
        // 检查说明
        if (null != prdBuChangeTodoPayload.getTodoDesc()) {
            update.set(qPrdBuChangeTodoDO.todoDesc,prdBuChangeTodoPayload.getTodoDesc());
        }
        // 状态
        if (null != prdBuChangeTodoPayload.getState()) {
            update.set(qPrdBuChangeTodoDO.state,prdBuChangeTodoPayload.getState());
        }
        // 备注
        if (StringUtils.isNotEmpty(prdBuChangeTodoPayload.getTodoRemark())) {
            update.set(qPrdBuChangeTodoDO.todoRemark,prdBuChangeTodoPayload.getTodoRemark());
        }
        long res = update.where(qPrdBuChangeTodoDO.id.eq(prdBuChangeTodoPayload.getId()))
                .execute();
        return res;
    
    }
    
}

