package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细
 */

@RestController
@RequestMapping("/api/prdPerformanceExamResDtl")
@RequiredArgsConstructor
@Api(value = "绩效考核结果明细", tags = {"绩效考核结果明细"})
public class PrdPerformanceExamResDtlController {

    private final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核结果明细")
    public TwOutputUtil<PrdPerformanceExamResDtlVO> get(@PathVariable Long id) {

        PrdPerformanceExamResDtlVO res = prdPerformanceExamResDtlService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-绩效考核结果明细")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        PrdPerformanceExamResDtlVO res = prdPerformanceExamResDtlService.save(prdPerformanceExamResDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-绩效考核结果明细")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        PrdPerformanceExamResDtlVO res = prdPerformanceExamResDtlService.update(prdPerformanceExamResDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核结果明细")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdPerformanceExamResDtlService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核结果明细")
    public TwOutputUtil<PagingVO<PrdPerformanceExamResDtlVO>> page(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {

        PagingVO<PrdPerformanceExamResDtlVO> res = prdPerformanceExamResDtlService.page(prdPerformanceExamResDtlQuery);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("updateByCondition")
    @ApiOperation("修改-绩效考核结果明细")
    public TwOutputUtil<Long> updateByCondition(@RequestBody PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        Long res = prdPerformanceExamResDtlService.updateByCondition(prdPerformanceExamResDtlPayload);
        return TwOutputUtil.ok(res);

    }

}

