package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResSearchQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResSearchVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonProjectExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
@RequiredArgsConstructor
public class ResSearchDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgEmployeeDO qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private final QPersonProjectExperienceDO qPersonProjectExperienceDO = QPersonProjectExperienceDO.personProjectExperienceDO;

    private final QPersonWorkExperienceDO qPersonWorkExperienceDO = QPersonWorkExperienceDO.personWorkExperienceDO;


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ResSearchVO> getJpaQueryResSelect() {

        return jpaQueryFactory.select(Projections.bean(ResSearchVO.class,
                        qdo.id,
                        qdo.userId,
//                        qdo.employeeName,
                        qdo.employeeNo,
                        qdo.resNo,
                        qdo.extString5,
                        qdo.resourceStatus,
                        qdo.userId,
                        qdo.eqvaRatio,
                        qdo.resNo,
                        qdoPerson.foreignName,
                        qdoPerson.mobile,
                        qdoPerson.email,
                        qdoPerson.personName.as("employeeName"),
                        qdoRef.orgId,
                        qdoRef.isDefault,
                        qdoOrg.orgName
//                        JPAExpressions.select(qPersonProjectExperienceDO.projName.as("orgName")).from(qPersonProjectExperienceDO).where(qPersonProjectExperienceDO.personId.eq(qdo.personId)).groupBy(qPersonProjectExperienceDO.personId)
                )).from(qdo).leftJoin(qdoPerson).on(qdo.personId.longValue().eq(qdoPerson.id.longValue()))
                .leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)));

    }


    /**
     * 拼装查询条件-资源查找
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ResSearchVO> getJpaQueryResWhere(ResSearchQuery query) {
        JPAQuery<ResSearchVO> jpaQuery = getJpaQueryResSelect();
        jpaQuery.where(qdo.resourceStatus.in(query.getResourceStatusList()));

        if (!ObjectUtils.isEmpty(query.getProjExperienceName()) || !ObjectUtils.isEmpty(query.getProjExperienceProduct()) || !ObjectUtils.isEmpty(query.getProjExperienceOt())) {
            jpaQuery.leftJoin(qPersonProjectExperienceDO).on(qPersonProjectExperienceDO.personId.eq(qdoPerson.id));
        }
        if (!ObjectUtils.isEmpty(query.getProjExperienceName())) {
            jpaQuery.where(qPersonProjectExperienceDO.projName.like(SqlUtil.toSqlLikeString(query.getProjExperienceName())));
        }
        if (!ObjectUtils.isEmpty(query.getProjExperienceProduct())) {
            jpaQuery.where(qPersonProjectExperienceDO.product.like(SqlUtil.toSqlLikeString(query.getProjExperienceProduct())));
        }
        if (!ObjectUtils.isEmpty(query.getProjExperienceOt())) {
            jpaQuery.where(qPersonProjectExperienceDO.company.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt()))
                    .or(qPersonProjectExperienceDO.industry.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt()))
                            .or(qPersonProjectExperienceDO.projRole.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt())))));
        }
        if (!ObjectUtils.isEmpty(query.getWorkExperienceCompany()) || !ObjectUtils.isEmpty(query.getWorkExperienceJob()) || !ObjectUtils.isEmpty(query.getWorkExperienceIndustry())) {
            jpaQuery.leftJoin(qPersonWorkExperienceDO).on(qPersonWorkExperienceDO.personId.eq(qdoPerson.id));
        }
        if (!ObjectUtils.isEmpty(query.getWorkExperienceCompany())) {
            jpaQuery.where(qPersonWorkExperienceDO.companyName.like(SqlUtil.toSqlLikeString(query.getWorkExperienceCompany())));
        }
        if (!ObjectUtils.isEmpty(query.getWorkExperienceJob())) {
            jpaQuery.where(qPersonWorkExperienceDO.jobtitle.like(SqlUtil.toSqlLikeString(query.getWorkExperienceJob())));
        }
        if (!ObjectUtils.isEmpty(query.getWorkExperienceIndustry())) {
            jpaQuery.where(qPersonWorkExperienceDO.industry.like(SqlUtil.toSqlLikeString(query.getWorkExperienceIndustry())));
        }
        if (!ObjectUtils.isEmpty(query.getEqvaRatioMax())) {
            jpaQuery.where(qdo.eqvaRatio.loe(query.getEqvaRatioMax()));
        }
        if (!ObjectUtils.isEmpty(query.getEqvaRatioMin())) {
            jpaQuery.where(qdo.eqvaRatio.goe(query.getEqvaRatioMin()));
        }
        if (!ObjectUtils.isEmpty(query.getEmployeeName())) {
            jpaQuery.where(qdoPerson.personName.like(SqlUtil.toSqlLikeString(query.getEmployeeName())).or(qdoPerson.foreignName.like(SqlUtil.toSqlLikeString(query.getEmployeeName()))));
        }
        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            jpaQuery.where(qdo.employeeNo.eq(query.getEmployeeNo()));
        }
        if (!ObjectUtils.isEmpty(query.getMobile())) {
            jpaQuery.where(qdoPerson.mobile.eq(query.getMobile()));
        }
        if (!ObjectUtils.isEmpty(query.getEmail())) {
            jpaQuery.where(qdoPerson.email.eq(query.getEmail()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.like(SqlUtil.toSqlLikeString(query.getExtString5())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
            jpaQuery.where(qdoRef.deleteFlag.eq(0));
            jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.personId);
        return jpaQuery;
    }

    public PagingVO<ResSearchVO> queryPaging(ResSearchQuery query) {
        JPAQuery<ResSearchVO> jpaQuery = getJpaQueryResWhere(query);
        QueryResults<ResSearchVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<ResSearchVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
