package com.elitesland.tw.tw5.server.prd.inv.controller;

import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票商品对象（百望）
 *
 * @author zoey
 * @date 2023-07-31
 */
@Api(tags = "发票商品对象（百望）")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/inv/invItem")
@Slf4j
public class InvItemController {

private final InvItemService invItemService;

    /**
     * 发票商品对象（百望）-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票商品对象（百望）-新增")
    public TwOutputUtil<InvItemVO> insert(@RequestBody InvItemPayload payload){
         return TwOutputUtil.ok(invItemService.insert(payload));
    }

    /**
     * 发票商品对象（百望）-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票商品对象（百望）-更新")
    public TwOutputUtil<InvItemVO> update(@RequestBody InvItemPayload payload){
        return TwOutputUtil.ok(invItemService.update(payload));
    }

    /**
     * 发票商品对象（百望）-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票商品对象（百望）-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvItemPayload payload){
        return TwOutputUtil.ok(invItemService.updateByKeyDynamic(payload));
    }

    /**
     * 发票商品对象（百望）-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票商品对象（百望）-主键查询")
    public TwOutputUtil<InvItemVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invItemService.queryByKey(key));
    }

    /**
     * 发票商品对象（百望）-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票商品对象（百望）-分页")
    public TwOutputUtil<PagingVO<InvItemVO>> paging(InvItemQuery query) {
        return TwOutputUtil.ok(invItemService.queryPaging(query));
    }

    /**
     * 发票商品对象（百望）-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票商品对象（百望）-查询列表")
    public TwOutputUtil<List<InvItemVO>> queryList(InvItemQuery query) {
        return TwOutputUtil.ok(invItemService.queryListDynamic(query));
    }

    /**
     * 发票商品对象（百望）-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票商品对象（百望）-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invItemService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

