package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.PrdOrgEmployeeConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdOrgEmployeeConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 员工-个人配置
 *
 * @folder 员工-个人配置
 * @author wangly
 * @date 2024-03-27
 */
@Api(tags = "员工-个人配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdOrgEmployeeConfig")
@Slf4j
public class PrdOrgEmployeeConfigController {

private final PrdOrgEmployeeConfigService prdOrgEmployeeConfigService;

    /**
     * 员工-个人配置-新增
     *
     * @folder 员工-个人配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("员工-个人配置-新增")
    public TwOutputUtil<PrdOrgEmployeeConfigVO> insert(@RequestBody PrdOrgEmployeeConfigPayload payload){
         return TwOutputUtil.ok(prdOrgEmployeeConfigService.insert(payload));
    }

    /**
     * 员工-个人配置-更新
     *
     * @folder 员工-个人配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("员工-个人配置-更新")
    public TwOutputUtil<PrdOrgEmployeeConfigVO> update(@RequestBody PrdOrgEmployeeConfigPayload payload){
        return TwOutputUtil.ok(prdOrgEmployeeConfigService.update(payload));
    }

    /**
     * 员工-个人配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 员工-个人配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("员工-个人配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdOrgEmployeeConfigPayload payload){
        return TwOutputUtil.ok(prdOrgEmployeeConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 员工-个人配置-主键查询
     *
     * @folder 员工-个人配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("员工-个人配置-主键查询")
    public TwOutputUtil<PrdOrgEmployeeConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdOrgEmployeeConfigService.queryByKey(key));
    }

    /**
     * 员工-个人配置-分页
     *
         * @folder 员工-个人配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("员工-个人配置-分页")
    public TwOutputUtil<PagingVO<PrdOrgEmployeeConfigVO>> paging(PrdOrgEmployeeConfigQuery query) {
        return TwOutputUtil.ok(prdOrgEmployeeConfigService.queryPaging(query));
    }

    /**
     * 员工-个人配置-查询列表
     *
     * @folder 员工-个人配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("员工-个人配置-查询列表")
    public TwOutputUtil<List<PrdOrgEmployeeConfigVO>> queryList(PrdOrgEmployeeConfigQuery query) {
        return TwOutputUtil.ok(prdOrgEmployeeConfigService.queryListDynamic(query));
    }

    /**
     * 员工-个人配置-删除
     *
         * @folder 员工-个人配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("员工-个人配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         prdOrgEmployeeConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

