package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @BelongsProject: tw-svr5
 * @BelongsPackage: com.elitesland.tw.tw5.server.prd.my.entity
 * @Author: dragonHuang
 * @CreateTime: 2023-08-30  14:06
 * @Description: TODO
 * @Version: 1.0
 */
@Entity
@Table(name = "t_overtime_application")
@org.hibernate.annotations.Table(appliesTo = "t_overtime_application", comment = "加班申请表")
@Data
@Where(clause = "delete_flag= 0")
public class OvertimeApplicationDO extends BaseModel {

    /**
     * 工作流实例id
     */
    @Comment("工作流实例id")
    @Column()
    private String processInstanceId;

    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projectId;

    /**
     * 用户id
     */
    @Comment("用户id")
    @Column()
    private Long userId;

    /**
     * 工作加班日期
     */
    @Comment("工作加班日期")
    @Column()
    private LocalDate overtimeWorkDate;

    /**
     * 工时
     */
    @Comment("工时")
    @Column()
    private BigDecimal overtimeWorkHour;

    /**
     * 加班工作说明
     */
    @Comment("加班工作说明")
    @Column()
    private String overtimeWorkDesc;

    /**
     * 审批状态, APPROVED, REJECT, APPROVING, CREATE
     */
    @Comment("审批状态, APPROVED, REJECT, APPROVING, CREATE")
    @Column()
    private String approveStatus;

    /**
     * 调休日期
     */
    @Comment("调休日期")
    @Column()
    private LocalDate restDate;

    /**
     * 调休状态, CREATE, APPROVING, RESTED
     */
    @Comment("调休状态, CREATE, APPROVING, RESTED")
    @Column()
    private String restStatus;
}
