package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description 用户假期表
 * @Date 2023/5/8
 */
@Entity
@Table(name = "t_user_vacation", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_user_vacation", comment = "用户假期表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class UserVacationDO extends BaseModel {

    /**
     * 4.0主键
     */
    @Comment("4.0主键")
    @Column()
    private Long idV4;

    /**
     * 用户id
     */
    @Comment("用户id")
    @Column()
    private Long userId;

    /**
     * 年度
     */
    @Comment("年度")
    @Column()
    private Long vacationYear;

    /**
     * 假期类型
     */
    @Comment("假期类型")
    @Column()
    private String vacationType;

    /**
     * 开始日期
     */
    @Comment("开始日期")
    @Column()
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;

    /**
     * 有效期
     */
    @Comment("有效期")
    @Column()
    private LocalDate expirationDate;

    /**
     * 总天数
     */
    @Comment("总天数")
    @Column(precision = 20, scale = 1)
    private BigDecimal totalDays;

    /**
     * 已用天数
     */
    @Comment("已用天数")
    @Column(precision = 20, scale = 1)
    private BigDecimal usedDays;

    /**
     * 加班ID
     */
    @Comment("加班id")
    @Column()
    private Long extrWorkId;

    /**
     * 是否加班调休
     */
    @Comment("是否加班调休")
    @Column()
    private String overtime;

    /**
     * 加班项目ID
     */
    @Comment("加班项目id")
    @Column()
    private Long extrWorkProjId;

    @Comment("事由类型")
    @Column()
    private String reasonType;

    @Comment("事由id")
    @Column()
    private Long reasonId;

}
