package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveAppliedQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveApplyService;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveApplyRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor
@Slf4j
public class RewardLeaveApplyServiceImpl extends BaseServiceImpl implements RewardLeaveApplyService {

    private final RewardLeaveApplyRepo rewardLeaveApplyRepo;
    private final RewardLeaveApplyDAO rewardLeaveApplyDAO;

    private final RewardLeaveConfigService rewardLeaveConfigService;

    private final WorkflowUtil workflowUtil;

    private final PmsProjectService pmsProjectService;

    private final CrmOpportunityService crmOpportunityService;

    private final CacheUtil cacheUtil;

    private final RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO;

    private final TaskInfoService taskInfoService;

    private final UserVacationService userVacationService;

    private final UdcUtil udcUtil;

    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;

    @Override
    public PagingVO<RewardLeaveApplyVO> queryPaging(RewardLeaveApplyQuery query) {
        return rewardLeaveApplyDAO.queryPaging(query);
    }

    @Override
    public List<RewardLeaveApplyVO> queryListDynamic(RewardLeaveApplyQuery query) {
        return rewardLeaveApplyDAO.queryListDynamic(query);
    }

    @Override
    public RewardLeaveApplyVO queryByKey(Long key) {
        RewardLeaveApplyDO entity = rewardLeaveApplyRepo.findById(key).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveApplyVO vo = RewardLeaveApplyConvert.INSTANCE.toVo(entity);

        RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
        detailQuery.setApplyId(entity.getId());
        List<RewardLeaveApplyDetailVO> rewardLeaveApplyDetailVOList = rewardLeaveApplyDetailDAO.queryListDynamic(detailQuery);
        rewardLeaveApplyDetailVOList = udcUtil.translateList(rewardLeaveApplyDetailVOList);
        vo.setDetailVOList(rewardLeaveApplyDetailVOList);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveApplyVO insert(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entityDo = RewardLeaveApplyConvert.INSTANCE.toDo(payload);
        RewardLeaveApplyVO rewardLeaveApplyVO = RewardLeaveApplyConvert.INSTANCE.toVo(rewardLeaveApplyRepo.save(entityDo));
        List<RewardLeaveApplyDetailPayload> rewardLeaveApplyDetailPayloadList = payload.getDetailPayloadList();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            rewardLeaveApplyDetailPayload.setId(null);
            rewardLeaveApplyDetailPayload.setApplyId(rewardLeaveApplyVO.getId());
        }
        List<RewardLeaveApplyDetailDO> detailDOS = RewardLeaveApplyDetailConvert.INSTANCE.toDos(rewardLeaveApplyDetailPayloadList);
        rewardLeaveApplyDetailDAO.saveAll(detailDOS);
        return rewardLeaveApplyVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveApplyVO update(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entity = rewardLeaveApplyRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveApplyDO entityDo = RewardLeaveApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        RewardLeaveApplyVO rewardLeaveApplyVO = RewardLeaveApplyConvert.INSTANCE.toVo(rewardLeaveApplyRepo.save(entity));
        //删除奖励假详情
        RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
        detailQuery.setApplyId(entity.getId());
        List<RewardLeaveApplyDetailVO> rewardLeaveApplyDetailVOList = rewardLeaveApplyDetailDAO.queryListDynamic(detailQuery);
        List<Long> detailIdList = rewardLeaveApplyDetailVOList.stream().map(e -> e.getId()).collect(Collectors.toList());
        rewardLeaveApplyDetailDAO.deleteSoft(detailIdList);
        //保存奖励假详情
        List<RewardLeaveApplyDetailPayload> rewardLeaveApplyDetailPayloadList = payload.getDetailPayloadList();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            rewardLeaveApplyDetailPayload.setId(null);
            rewardLeaveApplyDetailPayload.setApplyId(rewardLeaveApplyVO.getId());
        }
        List<RewardLeaveApplyDetailDO> detailDOS = RewardLeaveApplyDetailConvert.INSTANCE.toDos(rewardLeaveApplyDetailPayloadList);
        rewardLeaveApplyDetailDAO.saveAll(detailDOS);
        //创建任务包
        TaskPayload taskPayload = new TaskPayload();
        taskPayload.setReasonId(payload.getReasonId());
        taskPayload.setReasonType(payload.getReasonType());
        taskPayload.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskPayload.setReasonName(payload.getReasonName());
        taskPayload.setSourceId(rewardLeaveApplyVO.getId());
        taskPayload.setPlanStartDate(payload.getPlanStartDate());
        taskPayload.setPlanEndDate(payload.getPlanEndDate());
        List<TaskInfoPayload> taskInfoPayloads = new ArrayList<>();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setTaskResId(rewardLeaveApplyDetailPayload.getUserId());
            taskInfoPayload.setPlanEqva(rewardLeaveApplyDetailPayload.getEqva());
            taskInfoPayloads.add(taskInfoPayload);
        }
        taskPayload.setTaskInfoPayloads(taskInfoPayloads);
        taskInfoService.taskAutoCreate(taskPayload);
        return rewardLeaveApplyVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entity = rewardLeaveApplyRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = rewardLeaveApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            rewardLeaveApplyDAO.deleteSoft(keys);
        }
    }


    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveApplyVO submit(RewardLeaveApplyPayload payload) {

        //校验是否超过配置最大天数
        RewardLeaveConfigQuery configQuery = new RewardLeaveConfigQuery();
        RewardLeaveConfigVO configVO;
        //查询是否给项目单独配置
        List<RewardLeaveConfigVO> configVOList = new ArrayList<>();
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            configQuery.setProjectId(payload.getReasonId());
            configQuery.setLeaveYear((long) LocalDate.now().getYear());
            configVOList = rewardLeaveConfigService.queryListDynamic(configQuery);
        }
        if (!ObjectUtils.isEmpty(configVOList)) {
            configVO = configVOList.get(0);
        } else {
            RewardLeaveConfigQuery configQueryBU = new RewardLeaveConfigQuery();
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = pmsProjectService.queryByKey(payload.getReasonId());
                Long deliBuId = projectVO.getDeliBuId();
                configQueryBU.setDeliBuId(deliBuId);
            }
            //商机项目
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(payload.getReasonId());
                List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
                if (!ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                    configQueryBU.setDeliBuId(crmOpportunityListVOS.get(0).getPreSaleOrgId());
                } else {
                    throw new BusinessException("商机项目:" + payload.getReasonName() + "不存在");
                }
            }
            //BU项目
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = buProjectService.queryByKey(payload.getReasonId());
                configQueryBU.setDeliBuId(buProjectVO.getDeliBuId());
            }
            configQueryBU.setLeaveYear((long) LocalDate.now().getYear());
            List<RewardLeaveConfigVO> otConfigVOList = rewardLeaveConfigService.queryBuConfig(configQueryBU);
            if (ObjectUtils.isEmpty(otConfigVOList)) {
                throw new BusinessException("该事由未配置有关奖励假规则");
            }
            configVO = otConfigVOList.get(0);
        }
        if (!ObjectUtils.isEmpty(configVO.getJobGradeList())) {
            List<String> jobGradeList = Arrays.asList(configVO.getJobGradeList().split(","));
            configVO.setJobGrades(jobGradeList);
        }
        if (!ObjectUtils.isEmpty(configVO.getJobGrade2List())) {
            List<String> jobGrade2List = Arrays.asList(configVO.getJobGrade2List().split(","));
            configVO.setJobGrades2(jobGrade2List);
        }
        List<RewardLeaveApplyDetailPayload> detailPayloadList = payload.getDetailPayloadList();
        Map<Long, RewardLeaveApplyDetailPayload> userApplyDaysMap = new HashMap<>();
        for (RewardLeaveApplyDetailPayload detailPayload : detailPayloadList) {

            RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
            detailQuery.setUserId(detailPayload.getUserId());
            detailQuery.setReasonType(payload.getReasonType());
            detailQuery.setReasonId(payload.getReasonId());
            detailQuery.setWorkDate(detailPayload.getWorkDate());
            BigDecimal appliedDays = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty(rewardLeaveApplyDAO.countApplyDaysByDate(detailQuery))) {
                appliedDays = rewardLeaveApplyDAO.countApplyDaysByDate(detailQuery);
            }
            if (appliedDays.add(detailPayload.getDays()).compareTo(BigDecimal.ONE) > 0) {
                throw new BusinessException(cacheUtil.getUserName(detailPayload.getUserId()) + " " + detailPayload.getWorkDate() + " 奖励假申请天数超过1天");
            }
//            String userName = cacheUtil.getUserName(detailPayload.getUserId());
//            if (!ObjectUtils.isEmpty(configVO.getJobGrades())) {
//                if (!configVO.getJobGrades().contains(detailPayload.getJobGrade())) {
//                    userNameList.add(userName);
//                }
//            }
//            if (!ObjectUtils.isEmpty(configVO.getJobGrades2())) {
//                if (!ObjectUtils.isEmpty(detailPayload.getJobGrade2())) {
//                    if (!configVO.getJobGrades2().contains(detailPayload.getJobGrade2())) {
//                        userNameList.add(userName);
//                    }
//                }
//            }
            if (userApplyDaysMap.containsKey(detailPayload.getUserId())) {
                RewardLeaveApplyDetailPayload applyDetailPayload = userApplyDaysMap.get(detailPayload.getUserId());
                BigDecimal totalApplyDays = detailPayload.getDays().add(applyDetailPayload.getDays());
                applyDetailPayload.setDays(totalApplyDays);
                userApplyDaysMap.put(detailPayload.getUserId(), applyDetailPayload);
            } else {
                RewardLeaveApplyDetailPayload applyDetailPayload = new RewardLeaveApplyDetailPayload();
                applyDetailPayload.setDays(detailPayload.getDays());
                applyDetailPayload.setAppliedDays(detailPayload.getAppliedDays());
                applyDetailPayload.setJobGrade(detailPayload.getJobGrade());
                applyDetailPayload.setJobGrade2(detailPayload.getJobGrade2());
                applyDetailPayload.setUserId(detailPayload.getUserId());
                userApplyDaysMap.put(detailPayload.getUserId(), applyDetailPayload);
            }
        }
//        if (!ObjectUtils.isEmpty(userNameList)) {
//            String setAsString = String.join(", ", userNameList);
//            throw new BusinessException(setAsString + " 职级不在配置规则内");
//        }
        Set<String> jobGradeUserList = new HashSet<>();
        Set<String> applyDaysUserSet = new HashSet<>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        for (Long key : userApplyDaysMap.keySet()) {
            RewardLeaveApplyDetailPayload value = userApplyDaysMap.get(key);
            //合同项目
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = pmsProjectService.queryByKey(payload.getReasonId());
                Long pmUserId = projectVO.getPmResId();
                Long deliUserId = projectVO.getDeliUserId();
                if (!Objects.equals(loginUserId, deliUserId) && Objects.equals(value.getUserId(), pmUserId)) {
                    throw new BusinessException("项目经理的奖励假请联系交付负责人发起");
                }
            }
            //商机项目
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(payload.getReasonId());
                List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
                if (!ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                    Long preSaleUserId = crmOpportunityListVOS.get(0).getPreSaleUserId();
                    Long preSaleOrgId = crmOpportunityListVOS.get(0).getPreSaleOrgId();
                    PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(preSaleOrgId);
                    Long manageId = orgOrganizationVO.getManageId();
                    if (!Objects.equals(loginUserId, manageId) && Objects.equals(value.getUserId(), preSaleUserId)) {
                        throw new BusinessException("售前负责人的奖励假请联系售前BU Leader发起");
                    }
                }
            }
            //BU项目
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = buProjectService.queryByKey(payload.getReasonId());
                Long buProjectPmUserId = buProjectVO.getPmResId();
                Long buProjectDeliUserId = buProjectVO.getDeliUserId();
                if (!Objects.equals(loginUserId, buProjectDeliUserId) && Objects.equals(value.getUserId(), buProjectPmUserId)) {
                    throw new BusinessException("项目经理的奖励假请联系交付负责人发起");
                }
            }
            String userName = cacheUtil.getUserName(key);
            BigDecimal appliedDays = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty(configVO.getJobGrades())) {
                if (!configVO.getJobGrades().contains(value.getJobGrade())) {
                    jobGradeUserList.add(userName);
                }
            }
            if (!ObjectUtils.isEmpty(configVO.getJobGrades2())) {
                if (!ObjectUtils.isEmpty(value.getJobGrade2())) {
                    if (!configVO.getJobGrades2().contains(value.getJobGrade2())) {
                        jobGradeUserList.add(userName);
                    }
                }
            }
            if (!ObjectUtils.isEmpty(value.getAppliedDays())) {
                appliedDays = value.getAppliedDays();
            }
            if (appliedDays.add(value.getDays()).compareTo(configVO.getLeaveDaysUp()) > 0) {
                applyDaysUserSet.add(userName);
            }
        }
        if (!ObjectUtils.isEmpty(jobGradeUserList)) {
            String setAsString = String.join(", ", jobGradeUserList);
            throw new BusinessException(setAsString + ":职级不在配置规则内");
        }
        if (!ObjectUtils.isEmpty(applyDaysUserSet)) {
            String setAsString = String.join(", ", applyDaysUserSet);
            throw new BusinessException(setAsString + ":申请天数超过上限");
        }

        if (payload.getId() == null) {

            //保存申请单数据
            RewardLeaveApplyVO rewardLeaveApplyVO = insert(payload);

            //创建任务包 BU项目类型不创建任务包
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                TaskPayload taskPayload = new TaskPayload();
                taskPayload.setReasonId(payload.getReasonId());
                taskPayload.setReasonType(payload.getReasonType());
                taskPayload.setReasonName(payload.getReasonName());
                taskPayload.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
                taskPayload.setSourceId(rewardLeaveApplyVO.getId());
                taskPayload.setPlanStartDate(payload.getPlanStartDate());
                taskPayload.setPlanEndDate(payload.getPlanEndDate());
                List<TaskInfoPayload> taskInfoPayloads = new ArrayList<>();
                for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : payload.getDetailPayloadList()) {
                    TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
                    taskInfoPayload.setTaskResId(rewardLeaveApplyDetailPayload.getUserId());
                    taskInfoPayload.setPlanEqva(rewardLeaveApplyDetailPayload.getEqva());
                    taskInfoPayloads.add(taskInfoPayload);
                }
                taskPayload.setTaskInfoPayloads(taskInfoPayloads);
                taskInfoService.taskAutoCreate(taskPayload);
            }

            //发起流程
            HashMap<String, Object> variables = new HashMap<>();
            //事由类型为项目 交付Bu负责人审批
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = pmsProjectService.queryByKey(payload.getReasonId());
                Long deliBuId = projectVO.getDeliBuId();
                PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(deliBuId);
                Long manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_0utz02i", CollUtil.newArrayList(manageId));
            }
            //事由类型为商机 售前Bu负责人审批
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityVO crmOpportunityVO = crmOpportunityService.queryByKey(payload.getReasonId());
                Long preSaleOrgId = crmOpportunityVO.getPreSaleOrgId();
                PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(preSaleOrgId);
                Long manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_0utz02i", CollUtil.newArrayList(manageId));
            }
            //事由类型为BU项目 BU负责人审批
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = buProjectService.queryByKey(payload.getReasonId());
                PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(buProjectVO.getBuId());
                variables.put("Activity_0utz02i", CollUtil.newArrayList(orgOrganizationVO.getManageId()));
            }

            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.REWARD_LEAVE_APPLY.name(),
                    "奖励假申请流程-" + payload.getReasonName(),
                    rewardLeaveApplyVO.getId() + "",
                    variables)
            );

            //更新流程信息
            RewardLeaveApplyPayload procInstUpdate = new RewardLeaveApplyPayload();
            procInstUpdate.setId(rewardLeaveApplyVO.getId());
            procInstUpdate.setProcInstStatus(ProcInstStatus.APPROVING);
            procInstUpdate.setProcInstId(processInfo.getProcInstId());
            updateByKeyDynamic(procInstUpdate);
            return rewardLeaveApplyVO;
        } else {
            return update(payload);
        }

    }


    public List<RewardLeaveApplyDetailVO> queryAll(RewardLeaveApplyDetailQuery query) {
        return rewardLeaveApplyDAO.queryAll(query);
    }

    @Override
    public List<RewardLeaveApplyDetailVO> queryRewardDetailByVacationId(Long vacationId) {
        UserVacationVO userVacationVO = userVacationService.queryById(vacationId);
        RewardLeaveApplyDetailQuery query = new RewardLeaveApplyDetailQuery();
        query.setUserId(userVacationVO.getUserId());
        query.setReasonId(userVacationVO.getReasonId());
        query.setReasonType(userVacationVO.getReasonType());
        List<RewardLeaveApplyDetailVO> rewardLeaveApplyDetailVOList = queryAll(query);
        for (RewardLeaveApplyDetailVO rewardLeaveApplyDetailVO : rewardLeaveApplyDetailVOList) {
            PrdOrgEmployeeVO employeeVO = cacheUtil.getEmployee(userVacationVO.getUserId());
            rewardLeaveApplyDetailVO.setExtString5(employeeVO.getExtString5());
        }
        return rewardLeaveApplyDetailVOList;
    }

    @Override
    public List<RewardAppliedDaysVO> countDaysByUserAndReason(RewardLeaveAppliedQuery query) {
        List<RewardAppliedDaysVO> rewardAppliedDaysVOList = new ArrayList<>();
        for (Long userId : query.getUserIdList()) {
            RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
            detailQuery.setUserId(userId);
            detailQuery.setReasonType(query.getReasonType());
            detailQuery.setReasonId(query.getReasonId());
            BigDecimal appliedDays = rewardLeaveApplyDAO.queryAppliedDays(detailQuery);
            RewardAppliedDaysVO rewardAppliedDaysVO = new RewardAppliedDaysVO();
            rewardAppliedDaysVO.setUserId(userId);
            rewardAppliedDaysVO.setAppliedDays(appliedDays);
            rewardAppliedDaysVOList.add(rewardAppliedDaysVO);
        }
        return rewardAppliedDaysVOList;
    }
}
