package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author zoey
 * @Description:公司表
 * @date 2022/6/14 - 22:22
 */
@Entity
@Table(name = "prd_org_company", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "prd_org_company", comment = "公司表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgCompanyDO extends BaseModel {

    @Comment("地址簿id")
    @Column(name = "book_id", nullable = false)
    private Long bookId;

    @Comment("公司编号")
    @Column(name = "company_no", nullable = false)
    private String companyNo;

    @Comment("公司名称")
    @Column(name = "company_name", nullable = false)
    private String companyName;

    @Comment("行业")
    @Column(name = "company_industry")
    private String companyIndustry;

    @Comment("税号")
    @Column(name = "tax_no")
    private String taxNo;

    @Comment("电话")
    @Column(name = "company_phone")
    private String companyPhone;

    @Comment("邮箱")
    @Column(name = "company_email")
    private String companyEmail;

    @Comment("传真")
    @Column(name = "company_fax")
    private String companyFax;

    @Comment("省")
    @Column(name = "province")
    private String province;

    @Comment("省")
    @Column()
    private String provinceName;

    @Comment("市")
    @Column(name = "city")
    private String city;

    @Comment("市")
    @Column()
    private String cityName;

    @Comment("区")
    @Column(name = "district")
    private String district;

    @Comment("区")
    @Column()
    private String districtName;

    @Comment("详细地址")
    @Column(name = "company_address")
    private String companyAddress;

    @Comment("网址")
    @Column(name = "company_website")
    private String companyWebsite;

    @Comment("公司规模")
    @Column(name = "company_scale")
    private String companyScale;

    @Comment("交易货币")
    @Column(name = "currency")
    private String currency;

    @Comment("语言")
    @Column(name = "language")
    private String language;

    @Comment("公司性质")
    @Column(name = "company_nature")
    private String companyNature;

    @Comment("jde公司编号")
    @Column(name = "jde_company_no")
    private String jdeCompanyNo;

}
