package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 员工表
 *
 * @author 王顶
 * @date 2022/11/03
 */
@Entity
@Table(name = "prd_org_employee",
        indexes = {@Index(name = "person_index", columnList = "person_id"),
                @Index(name = "wecom_index", columnList = "wecom_id"),
                @Index(name = "userv4_index", columnList = "user_id_v4"),
                @Index(name = "user_index", columnList = "user_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee", comment = "员工表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("系统用户ID")
    @Column(name = "user_id")
    private Long userId;

    @Comment("tw4.0系统用户ID")
    @Column(name = "user_id_v4")
    private Long userIdV4;

    @Comment("企业微信ID")
    @Column(name = "wecom_id")
    private String wecomId;

//    @Comment("公司ID")
//    @Column()
//    private Long companyId;

    @Comment("公司bookId")
    @Column()
    private Long bookId;

    @Comment("员工编号")
    @Column()
    private String employeeNo;

    @Comment("员工名称")
    @Column()
    private String employeeName;

    @Comment("资源状态")
    @Column()
    private String resourceStatus;

    @Comment("人事状态")
    @Column()
    private String hrStatus;//0：有效，1：无效

    @Comment("入职日期")
    @Column()
    private LocalDate enrollDate;

    @Comment("安全级别")
    @Column()
    private Integer accessLevel;

    @Comment("岗位")
    @Column()
    private String jobs;

    @Comment("我的快捷入口")
    @Column()
    private String shortcutIds = "";

    @Comment("ticket")
    @Column()
    private String pcLoginTicket;

    @Comment("帮我吧顾问id")
    @Column()
    private Long bangwo8AdviserId;

    /**
     * 当量系数
     */
    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;

    @Comment("排序")
    @Column()
    private Integer sortIndex;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;

    private LocalDate extDate1;
    private LocalDate extDate2;
    private LocalDate extDate3;
    private LocalDate extDate4;
    private LocalDate extDate5;
    private LocalDate extDate6;
    private LocalDate extDate7;
    private LocalDate extDate8;

    @Comment("资源编号")
    @Column()
    private String resNo;

    @Comment("资源经理id")
    @Column()
    private Long resManagerId;

    @Comment("参加商务基本培训")
    @Column()
    private String busiTrainFlag;

    @Comment("进入平台时间")
    @Column()
    private LocalDate startDate;

    @Comment("最近一次任务时间")
    @Column()
    private LocalDate lastTaskDate;

    @Comment("是否需要用户账号")
    @Column()
    private String needUserFlag;

    @Comment("是否出差")
    @Column()
    private String busiTripFlag;

    @Comment("服务方式")
    @Column()
    private String serviceType;

    @Comment("服务时间开始")
    @Column()
    private LocalDate serviceClockFrom;

    @Comment("服务时间结束")
    @Column()
    private LocalDate serviceClockTo;

    @Comment("是否黑名单")
    @Column()
    private Boolean inBlackList;

    @Comment("无加班人员")
    @Column()
    private String inLieuFlag;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("合作方式")
    @Column()
    private String cooperationMode;

    @Comment("offer是否发放")
    @Column()
    private String deliverOffer;

    @Comment("offer未发放原因")
    @Column()
    private String noneOfferReason;

    @Comment("是否内推")
    @Column()
    private Boolean isJobInternalRecomm;

    @Comment("推荐人")
    @Column()
    private Long jobInternalRecommId;

    @Comment("工种分类一")
    @Column()
    private String jobClass1;

    @Comment("工种分类二")
    @Column()
    private String jobClass2;

    @Comment("长期/短期")
    @Column()
    private String periodFlag;

    @Comment("复合能力")
    @Column()
    private String capasetLevelId;

    @Comment("发薪方式")
    @Column()
    private String salaryMethod;

    @Comment("发薪周期")
    @Column()
    private String salaryPeriod;

    @Comment("结算方式")
    @Column()
    private String settleMethod;

    @Comment("实习开始日期")
    @Column()
    private LocalDate internshipStartDate;

    @Comment("百望电话")
    @Column()
    private String baiwangMobile;
}
