package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyModelPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyModelQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyModelService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyModelVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessModelDateEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessSelectionEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyModelConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyModelDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyModelDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyModelRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyModelServiceImpl extends BaseServiceImpl implements BusinessStrategyModelService {

    private final BusinessStrategyModelRepo businessStrategyModelRepo;
    private final BusinessStrategyModelDAO businessStrategyModelDAO;
    private final BusinessModelIndexService businessModelIndexService;
    private final BusinessModelIndexSettingService businessModelIndexSettingService;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<BusinessStrategyModelVO> queryPaging(BusinessStrategyModelQuery query){
        return businessStrategyModelDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyModelVO> queryListDynamic(BusinessStrategyModelQuery query){
        return businessStrategyModelDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyModelVO queryByKey(Long key) {
        BusinessStrategyModelDO entity = businessStrategyModelRepo.findById(key).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyModelVO vo = BusinessStrategyModelConvert.INSTANCE.toVo(entity);
        if(vo.getStandaryFlag()){
            //因为前端通过调用接口获取标准的数据
           // vo.setBusinessModelIndexVOList(findRfmSettingByDate(vo.getDateRange()));
            return vo;
        }
        BusinessModelIndexQuery businessModelIndexQuery = new BusinessModelIndexQuery();
        businessModelIndexQuery.setModelId(vo.getId());
        List<BusinessModelIndexVO> businessModelIndexVOS = businessModelIndexService.queryListDynamic(businessModelIndexQuery);
        BusinessModelIndexSettingQuery businessModelIndexSettingQuery = new BusinessModelIndexSettingQuery();
        businessModelIndexVOS.stream().forEach(businessModelIndexVO->{
            businessModelIndexSettingQuery.setIndexId(businessModelIndexVO.getId());
            businessModelIndexVO.setBusinessModelIndexSettingVOList(businessModelIndexSettingService.queryListDynamic(businessModelIndexSettingQuery));
        });
        vo.setBusinessModelIndexVOList(businessModelIndexVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyModelVO save(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelVO businessStrategyModelVO;
        //更新
        if(payload.getId()!=null){
            final Long modelId = payload.getId();
             businessStrategyModelVO = update(payload);
             //如果标准模版字段更新了 并且改为了标准模版
            if(payload.getStandaryFlag()){

                //由非标准改为了标准 标准改为非标准无需处理 因为标准只更新主表
                if(businessStrategyModelVO.getStandaryModifyFlag()){
                    //删除指标数据
                    businessModelIndexService.deleteSoftByModelId(modelId);
                    //删除指标明细数据
                    businessModelIndexSettingService.deleteSoftByModelId(modelId);
                }
                //组装RFM标准的指标数据 前端通过掉接口获取 此处冗余 无需处理
               // businessStrategyModelVO.setBusinessModelIndexVOList(findRfmSettingByDate(businessStrategyModelVO.getDateRange()));
                return businessStrategyModelVO;
            }

             if(!CollectionUtils.isEmpty(payload.getBusinessModelIndexPayloadList())){
                 //全删全插
                 Long indexId = 0L;
                 businessModelIndexService.deleteSoftByModelId(payload.getId());
                 List<BusinessModelIndexVO>  businessModelIndexVOList = new ArrayList<>();
                 for (BusinessModelIndexPayload businessModelIndexPayload:payload.getBusinessModelIndexPayloadList()) {
                     businessModelIndexPayload.setModelId(modelId);
                     BusinessModelIndexVO businessModelIndexVO = businessModelIndexService.insert(businessModelIndexPayload);
                     String indexName = businessModelIndexVO.getModelIndexName();
                     String sourceField = businessModelIndexVO.getSourceField();
                     indexId = businessModelIndexVO.getId();
                     if(!CollectionUtils.isEmpty(businessModelIndexPayload.getBusinessModelIndexSettingPayloadList())){
                         List<BusinessModelIndexSettingVO>  businessIndexSettingVOList = new ArrayList<>();
                         businessModelIndexSettingService.deleteSoftByModelIndexId(indexId);
                         for (BusinessModelIndexSettingPayload businessModelIndexSettingPayload: businessModelIndexPayload.getBusinessModelIndexSettingPayloadList()) {
                             if(businessModelIndexSettingPayload.getOptionScore()==null){
                                 throw TwException.error("","指标名称为:"+indexName+"的分数未编辑");
                             }
                             businessModelIndexSettingPayload.setModelId(modelId);
                             businessModelIndexSettingPayload.setIndexId(indexId);
                             businessModelIndexSettingPayload.setIndexName(indexName);
                             businessModelIndexSettingPayload.setSourceFiled(sourceField);
                             BusinessModelIndexSettingVO businessIndexSettingVO = businessModelIndexSettingService.insert(businessModelIndexSettingPayload);
                             businessIndexSettingVOList.add(businessIndexSettingVO);
                         }
                         businessModelIndexVO.setBusinessModelIndexSettingVOList(businessIndexSettingVOList);
                     }
                     businessModelIndexVOList.add(businessModelIndexVO);
                 }
                 businessStrategyModelVO.setBusinessModelIndexVOList(businessModelIndexVOList);
             }
        }else{
            //新增
            BusinessStrategyModelDO entityDo = BusinessStrategyModelConvert.INSTANCE.toDo(payload);
            businessStrategyModelVO = BusinessStrategyModelConvert.INSTANCE.toVo(businessStrategyModelRepo.save(entityDo));
            if(businessStrategyModelVO.getStandaryFlag()){
                return businessStrategyModelVO;
            }
            final Long modelId = businessStrategyModelVO.getId();
            if(!CollectionUtils.isEmpty(payload.getBusinessModelIndexPayloadList())){
                //直接插入 不需要删除
                Long indexId = 0L;
                List<BusinessModelIndexVO>  businessModelIndexVOList = new ArrayList<>();
                for (BusinessModelIndexPayload businessModelIndexPayload:payload.getBusinessModelIndexPayloadList()) {
                    businessModelIndexPayload.setModelId(modelId);
                    BusinessModelIndexVO businessModelIndexVO = businessModelIndexService.insert(businessModelIndexPayload);
                    indexId = businessModelIndexVO.getId();
                    String indexName = businessModelIndexVO.getModelIndexName();
                    String sourceField = businessModelIndexVO.getSourceField();
                    if(!CollectionUtils.isEmpty(businessModelIndexPayload.getBusinessModelIndexSettingPayloadList())){
                        List<BusinessModelIndexSettingVO>  businessIndexSettingVOList = new ArrayList<>();
                        for (BusinessModelIndexSettingPayload businessModelIndexSettingPayload: businessModelIndexPayload.getBusinessModelIndexSettingPayloadList()) {
                            if(businessModelIndexSettingPayload.getOptionScore()==null){
                                throw TwException.error("","指标名称为:"+indexName+"的分数未编辑");
                            }

                            businessModelIndexSettingPayload.setModelId(modelId);
                            businessModelIndexSettingPayload.setIndexId(indexId);
                            businessModelIndexSettingPayload.setIndexName(indexName);
                            businessModelIndexSettingPayload.setSourceFiled(sourceField);
                            BusinessModelIndexSettingVO businessIndexSettingVO = businessModelIndexSettingService.insert(businessModelIndexSettingPayload);
                            businessIndexSettingVOList.add(businessIndexSettingVO);
                        }
                        businessModelIndexVO.setBusinessModelIndexSettingVOList(businessIndexSettingVOList);
                    }
                    businessModelIndexVOList.add(businessModelIndexVO);
                }
                businessStrategyModelVO.setBusinessModelIndexVOList(businessModelIndexVOList);
            }
        }
        return businessStrategyModelVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyModelVO update(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelDO entity = businessStrategyModelRepo.findById(payload.getId()).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyModelDO entityDo = BusinessStrategyModelConvert.INSTANCE.toDo(payload);
        Boolean standaryModify = false;
        if(!entity.getStandaryFlag().equals(payload.getStandaryFlag())){
            standaryModify = true;
        }
        entity.copy(entityDo);
        BusinessStrategyModelVO businessStrategyModelVO = BusinessStrategyModelConvert.INSTANCE.toVo(businessStrategyModelRepo.save(entity));
        businessStrategyModelVO.setStandaryModifyFlag(standaryModify);
        return businessStrategyModelVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyModelPayload payload) {
        BusinessStrategyModelDO entity = businessStrategyModelRepo.findById(payload.getId()).orElseGet(BusinessStrategyModelDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyModelDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            //先判断有没有关联的启用策略 如果有不能编辑
            Long count = queryStrategyByModelIdsAndStrategyStatus(keys, BusinessStrategyStatusEnum.OPEN.getCode());
            if(count>0){
                throw TwException.error("","模型已被策略关联且启用，不可删除");
            }
            businessStrategyModelDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<BusinessModelIndexVO> findRfmSettingByDate(String dateKey) {

        if(BusinessModelDateEnum.YEAR.getCode().equals(dateKey)){
             return getData(BusinessSelectionEnum.YEAR_MONTH.getCode(), BusinessSelectionEnum.YEAR_FREQUENCY.getCode(), BusinessSelectionEnum.YEAR_AMOUNT.getCode());
        }else{
           return getData(BusinessSelectionEnum.HALFYEAR_MONTH.getCode(), BusinessSelectionEnum.HALFYEAR_FREQUENCY.getCode(), BusinessSelectionEnum.HALFYEAR_AMOUNT.getCode());
        }
    }

    /**
     *
     * 根据模型的时间范围选择来返回对应的rfm指标数据
     *
     *
     * **/
    public List<BusinessModelIndexVO> getData(String monthKey,String frequencyKey,String amountKey){
        List<BusinessModelIndexVO> businessModelIndexVOList= new ArrayList<>();
        //通过key获取对应的系统选择项
        PrdSystemSelectionVO monthSelection = cacheUtil.getSystemSelection(monthKey);
        PrdSystemSelectionVO frequencySelection = cacheUtil.getSystemSelection(frequencyKey);
        PrdSystemSelectionVO amountSelection = cacheUtil.getSystemSelection(amountKey);
        //初始化三个指标list
        List<PrdSystemSelectionVO> monthChildren = monthSelection.getChildren();
        List<PrdSystemSelectionVO> frequencyChildren = frequencySelection.getChildren();
        List<PrdSystemSelectionVO> amountChildren = amountSelection.getChildren();
        //初始化三个指标配置list
        List<BusinessModelIndexSettingVO>  monthIndexSettingVOList = new ArrayList<>();
        List<BusinessModelIndexSettingVO>  frequencyIndexSettingVOList = new ArrayList<>();
        List<BusinessModelIndexSettingVO>  amountIndexSettingVOList = new ArrayList<>();
        //月份
        BusinessModelIndexVO monthModelIndexVO = new BusinessModelIndexVO();
        monthModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.R.getCode());
        monthModelIndexVO.setWeight(BigDecimal.ZERO);
        monthModelIndexVO.setSourceField(BusinessStrategyIndexEnum.R.getCode());
        monthChildren.stream().forEach(children->{
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.R.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.R.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            monthIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        monthModelIndexVO.setBusinessModelIndexSettingVOList(monthIndexSettingVOList);
        //频率
        BusinessModelIndexVO frequencyModelIndexVO = new BusinessModelIndexVO();
        frequencyModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.F.getCode());
        frequencyModelIndexVO.setWeight(BigDecimal.ZERO);
        frequencyModelIndexVO.setSourceField(BusinessStrategyIndexEnum.F.getCode());

        frequencyChildren.stream().forEach(children->{
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.F.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.F.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            frequencyIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        frequencyModelIndexVO.setBusinessModelIndexSettingVOList(frequencyIndexSettingVOList);

        //金额
        BusinessModelIndexVO amountModelIndexVO = new BusinessModelIndexVO();
        amountModelIndexVO.setModelIndexName(BusinessStrategyIndexEnum.M.getCode());
        amountModelIndexVO.setWeight(BigDecimal.ZERO);
        amountModelIndexVO.setSourceField(BusinessStrategyIndexEnum.M.getCode());
        amountChildren.stream().forEach(children->{
            BusinessModelIndexSettingVO businessModelIndexSettingVO = new BusinessModelIndexSettingVO();
            businessModelIndexSettingVO.setIndexName(BusinessStrategyIndexEnum.M.getCode());
            businessModelIndexSettingVO.setSourceFiled(BusinessStrategyIndexEnum.M.getCode());
            businessModelIndexSettingVO.setSourceFiledOption(children.getSelectionValue());
            businessModelIndexSettingVO.setSourceFiledOptionDesc(children.getSelectionName());
            businessModelIndexSettingVO.setOptionScore(new BigDecimal(children.getExtString1()));
            businessModelIndexSettingVO.setExt2(children.getExtString2());
            businessModelIndexSettingVO.setExt3(children.getExtString3());
            amountIndexSettingVOList.add(businessModelIndexSettingVO);
        });
        amountModelIndexVO.setBusinessModelIndexSettingVOList(amountIndexSettingVOList);
        //最终组装为返回对象
        businessModelIndexVOList.add(monthModelIndexVO);
        businessModelIndexVOList.add(frequencyModelIndexVO);
        businessModelIndexVOList.add(amountModelIndexVO);
        return businessModelIndexVOList;
    }


    @Override
    public Long queryStrategyByModelIdsAndStrategyStatus(List<Long>  modelIdList,String strategyStatus){
        return businessStrategyModelDAO.queryStrategyByModelIdsAndStrategyStatus(modelIdList,strategyStatus);
    }

    @Override
    public Boolean checkAssociationStrategy(Long modelId) {
        //先判断有没有关联的启用策略 如果有不能编辑
        Boolean checkFlag = false;
        List<Long> modelIdList = new ArrayList<>();
        modelIdList.add(modelId);
        Long count = queryStrategyByModelIdsAndStrategyStatus(modelIdList, BusinessStrategyStatusEnum.OPEN.getCode());
        if(count>0){
            checkFlag = true;
        }
        return checkFlag;
    }
}
