package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 资源规划
 *
 * @author xxb
 * @date 2023-08-11
 */
@Entity
@Table(name = "pms_resource_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_resource_plan", comment = "资源规划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsResourcePlanDO extends BaseModel implements Serializable  {
    /** 计划类型 */
    @Comment("计划类型")
    @Column()
    private String planType;
    /** 关联对象ID */
    @Comment("关联对象ID")
    @Column()
    private Long objId;
    /** 关联对象 */
    @Comment("关联对象")
    @Column()
    private String objName;
    /** 开始日期 */
    @Comment("开始日期")
    @Column()
    private LocalDate startDate;
    /** 结束日期 */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;

    /** 资源规划状态 0正常 */
    @Comment("资源规划状态 0正常")
    @Column()
    private String planningStatus;

    @Comment("资源规划周期: WEEK周 MONTH月")
    @Column()
    private String resourcePlanningCycle;
    /** 持续时长 */
    @Comment("持续时长")
    @Column()
    private Integer duration;

    /** 以下是预留字段 */

    /** 商机销售阶段  --- 给商机类型资源规划用的 */
    @Comment("商机销售阶段  --- 给商机类型资源规划用的")
    @Column()
    private String salePhase;
    /** 成单概率交付角度 --- 给商机类型资源规划用的 */
    @Comment("成单概率交付角度 --- 给商机类型资源规划用的")
    @Column()
    private String probability;
    /** 版本号  */
    @Comment("版本号 ")
    @Column()
    private String versionNo;
    /** 变更原因 */
    @Comment("变更原因")
    @Column()
    private String changeReason;
    /** 交付负责人 */
    @Comment("交付负责人")
    @Column()
    private Long deliResId;
    /** BUID */
    @Comment("BUID")
    @Column()
    private Long buId;


    public void copy(PmsResourcePlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
