package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaCheckPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaCheckQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsMaCheckService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaCheckVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsMaCheckConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsMaCheckDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsMaCheckDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsMaCheckRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * 项目经理任务书核对
 *
 * @author carl
 * @date 2023-09-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsMaCheckServiceImpl extends BaseServiceImpl implements PmsMaCheckService {

    private final PmsMaCheckRepo pmsMaCheckRepo;
    private final PmsMaCheckDAO pmsMaCheckDAO;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsMaCheckVO insertOrUpdate(PmsMaCheckPayload payload) {
        PmsMaCheckDO entityDo = PmsMaCheckConvert.INSTANCE.toDo(payload);
        if (entityDo.getFinishFlag() != null && entityDo.getFinishFlag() == 1) {
            entityDo.setFinishTime(LocalDateTime.now());
        } else {
            entityDo.setFinishTime(null);
        }
        return PmsMaCheckConvert.INSTANCE.toVo(pmsMaCheckRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchInsertOrUpdate(List<PmsMaCheckPayload> payloads) {
        if (!ObjectUtils.isEmpty(payloads)) {
            List<PmsMaCheckDO> dos = new ArrayList<>();
            payloads.forEach(payload -> {
                PmsMaCheckDO entityDo = PmsMaCheckConvert.INSTANCE.toDo(payload);
                if (entityDo.getFinishFlag() != null && entityDo.getFinishFlag() == 1) {
                    entityDo.setFinishTime(LocalDateTime.now());
                } else {
                    entityDo.setFinishTime(null);
                }
                dos.add(entityDo);
            });
            pmsMaCheckRepo.saveAll(dos);
        } else {
            throw TwException.error("", "保存数据不可为空");
        }
    }

    @Override
    public PagingVO<PmsMaCheckVO> queryPaging(PmsMaCheckQuery query) {
        return pmsMaCheckDAO.queryPaging(query);
    }

    @Override
    public List<PmsMaCheckVO> queryListDynamic(PmsMaCheckQuery query) {
        List<PmsMaCheckVO> pmsMaCheckVOS = pmsMaCheckDAO.queryConfigList(query);
        if (!ObjectUtils.isEmpty(pmsMaCheckVOS)) {
            List<PmsMaCheckVO> pmsMaCheckVOS1 = pmsMaCheckDAO.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(pmsMaCheckVOS1)) {
                pmsMaCheckVOS.forEach(vo -> {
                    Optional<PmsMaCheckVO> first = pmsMaCheckVOS1.stream().filter(vo1 -> vo.getConfigId().equals(vo1.getConfigId())).findFirst();
                    if (first.isPresent()) {
                        PmsMaCheckVO pmsMaCheckVO = first.get();
                        vo.setFinishFlag(pmsMaCheckVO.getFinishFlag());
                        vo.setFinishTime(pmsMaCheckVO.getFinishTime());
                        vo.setId(pmsMaCheckVO.getId());
                        vo.setProjId(pmsMaCheckVO.getProjId());
                    }
                });
            }
        }
        pmsMaCheckVOS.sort(Comparator.comparing(PmsMaCheckVO::getSortIndex));
        return pmsMaCheckVOS;
    }

    @Override
    public PmsMaCheckVO queryByKey(Long key) {
        PmsMaCheckDO entity = pmsMaCheckRepo.findById(key).orElseGet(PmsMaCheckDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsMaCheckVO vo = PmsMaCheckConvert.INSTANCE.toVo(entity);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsMaCheckPayload payload) {
        PmsMaCheckDO entity = pmsMaCheckRepo.findById(payload.getId()).orElseGet(PmsMaCheckDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsMaCheckDAO.updateByKeyDynamic(payload);
        return result;
    }


}
