package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanDaysPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanDaysVO;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsResourcePlanDaysConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanDaysDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanDaysDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanDaysRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 资源计划人天明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsResourcePlanDaysServiceImpl extends BaseServiceImpl implements PmsResourcePlanDaysService {

    private final PmsResourcePlanDaysRepo pmsResourcePlanDaysRepo;
    private final PmsResourcePlanDaysDAO pmsResourcePlanDaysDAO;

    //@Override
    public PagingVO<PmsResourcePlanDaysVO> queryPaging(PmsResourcePlanDaysQuery query) {
        return pmsResourcePlanDaysDAO.queryPaging(query);
    }

    //@Override
    public List<PmsResourcePlanDaysVO> queryListDynamic(PmsResourcePlanDaysQuery query) {
        return pmsResourcePlanDaysDAO.queryListDynamic(query);
    }

    //@Override
    public PmsResourcePlanDaysVO queryByKey(Long key) {
        PmsResourcePlanDaysDO entity = pmsResourcePlanDaysRepo.findById(key).orElseGet(PmsResourcePlanDaysDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsResourcePlanDaysVO vo = PmsResourcePlanDaysConvert.INSTANCE.toVo(entity);
        return vo;
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public PmsResourcePlanDaysVO insert(PmsResourcePlanDaysPayload payload) {
        PmsResourcePlanDaysDO entityDo = PmsResourcePlanDaysConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanDaysConvert.INSTANCE.toVo(pmsResourcePlanDaysRepo.save(entityDo));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public List<PmsResourcePlanDaysVO> batchInsert(List<PmsResourcePlanDaysPayload> daysPayloads) {
        List<PmsResourcePlanDaysDO> list = new ArrayList<>();
        daysPayloads.forEach(payload -> list.add(PmsResourcePlanDaysConvert.INSTANCE.toDo(payload)));
        return PmsResourcePlanDaysConvert.INSTANCE.toVoList(pmsResourcePlanDaysRepo.saveAll(list));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public PmsResourcePlanDaysVO update(PmsResourcePlanDaysPayload payload) {
        PmsResourcePlanDaysDO entity = pmsResourcePlanDaysRepo.findById(payload.getId()).orElseGet(PmsResourcePlanDaysDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsResourcePlanDaysDO entityDo = PmsResourcePlanDaysConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsResourcePlanDaysConvert.INSTANCE.toVo(pmsResourcePlanDaysRepo.save(entity));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsResourcePlanDaysPayload payload) {
        PmsResourcePlanDaysDO entity = pmsResourcePlanDaysRepo.findById(payload.getId()).orElseGet(PmsResourcePlanDaysDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsResourcePlanDaysDAO.updateByKeyDynamic(payload);
        return result;
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsResourcePlanDaysDAO.deleteSoft(keys);
        }
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByPlanIdAndStartDate(Long planId, Set<LocalDate> startDates) {
        if (!startDates.isEmpty() && !ObjectUtils.isEmpty(planId)) {
            pmsResourcePlanDaysDAO.deleteSoftByPlanIdAndStartDate(planId, startDates);
        }
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByRoleDetailId(Long roleDetailId) {
        pmsResourcePlanDaysDAO.deleteSoftByRoleDetailId(roleDetailId);
    }

}
