package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 采购协议关联协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Entity
@Table(name = "t_purchase_agreement_association", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_agreement_association", comment = "采购协议关联协议")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseAgreementAssociationDO extends BaseModel implements Serializable  {
    /** 协议id*/
    @Comment("协议id")
    @Column
    private Long agreementId;
    /** 序号 */
    @Comment("序号")
    @Column()
    private Long no;
    /** 关联协议 */
    @Comment("关联协议")
    @Column()
    private Long associationAgreementId;
    /** 供应商地址簿ID */
    @Comment("供应商地址簿ID")
    @Column()
    private Long supplierBookId;
    /** 协议编码 */
    @Comment("协议编码")
    @Column()
    private String agreementCode;
    /** 协议名称 */
    @Comment("协议名称")
    @Column()
    private String agreementName;
    /** 协议内容说明 */
    @Comment("协议内容说明")
    @Column()
    private String associationContentDescription;

    public void copy(PurchaseAgreementAssociationDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
