package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 人力资源结算费率
 *
 * @author lemon
 * @date 2023-11-02
 */
@Entity
@Table(name = "res_set_rate", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "res_set_rate", comment = "人力资源结算费率")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ResSetRateDO extends BaseModel implements Serializable  {
    /** 采购协议单据ID */
    @Comment("采购协议单据ID")
    @Column()
    private Long documentId;
    /** 采购协议单据编号 */
    @Comment("采购协议单据编号")
    @Column()
    private String documentNo;
    /** 服务费率 */
    @Comment("服务费率")
    @Column()
    private BigDecimal serviceRate;
    /** 开始金额 */
    @Comment("开始金额")
    @Column()
    private BigDecimal startAtm;
    /** 结束金额 */
    @Comment("结束金额")
    @Column()
    private BigDecimal endAtm;

    public void copy(ResSetRateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
