package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Api(tags = "invdtl")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conInvBatchInvdtl")
@Slf4j
public class ConInvBatchInvdtlController {

    private final ConInvBatchInvdtlService conInvBatchInvdtlService;

    /**
     * invdtl-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("invdtl-新增")
    public TwOutputUtil<ConInvBatchInvdtlVO> insert(@RequestBody ConInvBatchInvdtlPayload payload) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.insert(payload));
    }

    /**
     * invdtl-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("invdtl-更新")
    public TwOutputUtil<ConInvBatchInvdtlVO> update(@RequestBody ConInvBatchInvdtlPayload payload) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.update(payload));
    }

    /**
     * invdtl-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("invdtl-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConInvBatchInvdtlPayload payload) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.updateByKeyDynamic(payload));
    }

    /**
     * invdtl-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("invdtl-主键查询")
    public TwOutputUtil<ConInvBatchInvdtlVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.queryByKey(key));
    }

    /**
     * invdtl-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("invdtl-分页")
    public TwOutputUtil<PagingVO<ConInvBatchInvdtlVO>> paging(ConInvBatchInvdtlQuery query) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.queryPaging(query));
    }

    /**
     * 开票明细-导出
     *
     * @param query 查询
     */
    @GetMapping("/exportList")
    @UdcNameClass
    @ApiOperation("开票明细-导出")
    public void export(ConInvBatchInvdtlQuery query, HttpServletResponse response) throws IOException {
        conInvBatchInvdtlService.exportList(query, response);
    }

    /**
     * invdtl-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("invdtl-查询列表")
    public TwOutputUtil<List<ConInvBatchInvdtlVO>> queryList(ConInvBatchInvdtlQuery query) {
        return TwOutputUtil.ok(conInvBatchInvdtlService.queryListDynamic(query));
    }

    /**
     * invdtl-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("invdtl-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conInvBatchInvdtlService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

