package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConEpibolyCostConDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConDRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Repository
@RequiredArgsConstructor
public class ConEpibolyCostConDDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConEpibolyCostConDRepo repo;
    private final QConEpibolyCostConDDO qdo = QConEpibolyCostConDDO.conEpibolyCostConDDO;
    private final QConEpibolyCostConDO qdoMain = QConEpibolyCostConDO.conEpibolyCostConDO;
    private final QSaleConContractDO qdoCon = QSaleConContractDO.saleConContractDO;
    //private final QCrmCustomerDO qdoCrmCust = QCrmCustomerDO.crmCustomerDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConEpibolyCostConDVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConEpibolyCostConDVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 外包费用确认单ID
                qdo.epibolyCostConId,
                // 工作类型
                qdo.workType,
                // 具体理由
                qdo.reason,
                // 伙伴类型
                qdo.partnerType,
                // 合作方
                qdo.collaborator,
                // 基于
                qdo.base,
                qdo.costCondIdV4,
                // 比例
                qdo.proportion,
                // 金额
                qdo.amt,
                // 税费率
                qdo.taxRate,
                // 税费
                qdo.taxCost,
                // 税费承担方
                qdo.taxPayer,
                // 净支付额
                qdo.netPay,
                // 具体支付方式
                qdo.paymentMethod,
                // 收款节点
                qdo.receStage,
                // 线下合同&沟通签署状态
                qdo.contractStatus,
                // 联系人姓名
                qdo.liaisonName,
                // 联系电话
                qdo.liaisonPhone,
                // 关联单据类型
                qdo.docType,
                // 关联单据号
                qdo.documentNumber,
                // 明细状态
                qdo.detailedStatus,
                // 父明细
                qdo.parentId,
                // 需求单号
                qdoMain.epibolyCostNo.as("epibolyCostConCode"),
                // 申请人Id
                qdoMain.applyUserId,
                // 申请日期
                qdoMain.applyDate,
                // 申请Bu_Id
                qdoMain.applyBuId,
                // 参考合同号
                qdoCon.referCode,
                // 销售合同名称
                qdoCon.name.as("saleConName"),
                // 外包费用备注
                qdoMain.remark.as("mainRemark"),
                // 客户Id
                qdoCon.custId,
                // 客户名称
                qdoCon.custName,
                // 关联合同状态
                qdoCon.status.as("relatedContractStatus"),
                // 关联合同所关联项目Id
                qPmsProjectDO.id.as("projId"),
                // 关联单据类型
                qdo.docType,
                // 关联单据编号
                qdo.documentNumber,
                // 销售合同Id
                qdoCon.id.as("saleConId")
        )).from(qdo)
                .leftJoin(qdoMain).on(qdoMain.id.longValue().eq(qdo.epibolyCostConId.longValue()))
                .leftJoin(qdoCon).on(qdoMain.contractId.longValue().eq(qdoCon.id.longValue()))
                .leftJoin(qPmsProjectDO).on(qPmsProjectDO.contractId.eq(qdoMain.contractId))
                .leftJoin(qdoRef).on(qdoCon.saleManUserId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConEpibolyCostConDVO> getJpaQueryWhere(ConEpibolyCostConDQuery query) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConEpibolyCostConDQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo)
                .leftJoin(qdoMain).on(qdoMain.id.longValue().eq(qdo.epibolyCostConId.longValue()))
                .leftJoin(qdoCon).on(qdoMain.contractId.longValue().eq(qdoCon.id.longValue()))
                .where(where(query));
        if (Boolean.FALSE.equals(query.getQueryDtlFlag())) {
            jpaQuery.where(qdo.parentId.isNull());
        }
        return jpaQuery.fetchOne();
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConEpibolyCostConDQuery query) {
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 外包费用确认单ID 精确 */
        if (!ObjectUtils.isEmpty(query.getEpibolyCostConId())) {
            list.add(qdo.epibolyCostConId.eq(query.getEpibolyCostConId()));
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 具体理由 模糊 */
        if (!ObjectUtils.isEmpty(query.getReason())) {
            list.add(qdo.reason.like(SqlUtil.toSqlLikeString(query.getReason())));
        }
        /** 伙伴类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerType())) {
            list.add(qdo.partnerType.eq(query.getPartnerType()));
        }
        /** 合作方 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborator())) {
            list.add(qdo.collaborator.eq(query.getCollaborator()));
        }
        /** 基于 精确 */
        if (!ObjectUtils.isEmpty(query.getBase())) {
            list.add(qdo.base.eq(query.getBase()));
        }
        /** 比例 精确 */
        if (!ObjectUtils.isEmpty(query.getProportion())) {
            list.add(qdo.proportion.eq(query.getProportion()));
        }
        /** 金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmt())) {
            list.add(qdo.amt.eq(query.getAmt()));
        }
        /** 税费率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 税费 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxCost())) {
            list.add(qdo.taxCost.eq(query.getTaxCost()));
        }
        /** 税费承担方 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxPayer())) {
            list.add(qdo.taxPayer.eq(query.getTaxPayer()));
        }
        /** 净支付额 精确 */
        if (!ObjectUtils.isEmpty(query.getNetPay())) {
            list.add(qdo.netPay.eq(query.getNetPay()));
        }
        /** 具体支付方式 精确 */
        if (!ObjectUtils.isEmpty(query.getPaymentMethod())) {
            list.add(qdo.paymentMethod.eq(query.getPaymentMethod()));
        }
        /** 线下合同&沟通签署状态 精确 */
        if (!ObjectUtils.isEmpty(query.getContractStatus())) {
            list.add(qdo.contractStatus.eq(query.getContractStatus()));
        }
        /** 联系人姓名 精确 */
        if (!ObjectUtils.isEmpty(query.getLiaisonName())) {
            list.add(qdo.liaisonName.eq(query.getLiaisonName()));
        }
        /** 联系电话 精确 */
        if (!ObjectUtils.isEmpty(query.getLiaisonPhone())) {
            list.add(qdo.liaisonPhone.eq(query.getLiaisonPhone()));
        }
        /** 关联单据类型 精确 */
        if (!ObjectUtils.isEmpty(query.getDocType())) {
            list.add(qdo.docType.eq(query.getDocType()));
        }
        /** 关联单据号 精确 */
        if (!ObjectUtils.isEmpty(query.getDocumentNumber())) {
            list.add(qdo.documentNumber.eq(query.getDocumentNumber()));
        }
        /** 父明细 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }

        /** 外包费用单号 模糊 */
        if (!ObjectUtils.isEmpty(query.getEpibolyCostConCode())) {
            list.add(qdoMain.epibolyCostNo.like(SqlUtil.toSqlLikeString(query.getEpibolyCostConCode())));
        }
        /** 申请人BU 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyBuId())) {
            list.add(qdoMain.applyBuId.eq(query.getApplyBuId()));
        }
        /** 申请人Id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qdoMain.applyUserId.eq(query.getApplyUserId()));
        }
        /** 申请日期范围 区间*/
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdoMain.applyDate.between(query.getApplyDate().get(0), query.getApplyDate().get(1)));
        }
        /** 参考合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
            list.add(qdoCon.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
        }
        /** 客户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdoCon.custId.eq(query.getCustId()));
        }
        /** 明细状态 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailedStatus())) {
            list.add(qdo.detailedStatus.eq(query.getDetailedStatus()));
        }
        /** 当前登录人是合同签单bu负责人 */
        if (!CollectionUtils.isEmpty(query.getInchargeSignBus())) {
            list.add(qdoCon.signBuId.in(query.getInchargeSignBus()));
        } else if (!query.getAuthAll()) {
            // 无权限
            list.add(qdo.id.eq(0L));
        }
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            list.add(qdo.id.in(query.getIdList()));
        }

//        /**
//         * 关于列表权限
//         */
//        if ((!CollectionUtils.isEmpty(query.getOrgIdsByPermission()) || (!CollectionUtils.isEmpty(query.getUserIdsByPermission())))) {
//            list.add(qdoCon.deliBuId.in(query.getOrgIdsByPermission()).or(qdoCon.signBuId.in(query.getOrgIdsByPermission())).or(qdoRef.orgId.in(query.getOrgIdsByPermission()))
//                    .or(qdoCon.saleManUserId.in(query.getUserIdsByPermission())).or(qdoCon.deliUserId.in(query.getUserIdsByPermission())).or(qdoCon.createUserId.in(query.getUserIdsByPermission())));
//        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConEpibolyCostConDVO queryByKey(Long id) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConEpibolyCostConDVO> queryListDynamic(ConEpibolyCostConDQuery query) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQueryWhere(query);
        if (Boolean.FALSE.equals(query.getQueryDtlFlag())) {
            jpaQuery.where(qdo.parentId.isNull());
        }
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConEpibolyCostConDVO> queryPaging(ConEpibolyCostConDQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQueryWhere(query);
        List<ConEpibolyCostConDVO> result = jpaQuery
                .where(qdo.parentId.isNull())
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConEpibolyCostConDVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConEpibolyCostConDDO save(ConEpibolyCostConDDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConEpibolyCostConDDO> saveAll(List<ConEpibolyCostConDDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConEpibolyCostConDPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 外包费用确认单ID
        if (payload.getEpibolyCostConId() != null) {
            update.set(qdo.epibolyCostConId, payload.getEpibolyCostConId());
        }
        // 工作类型
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 具体理由
        if (payload.getReason() != null) {
            update.set(qdo.reason, payload.getReason());
        }
        // 伙伴类型
        if (payload.getPartnerType() != null) {
            update.set(qdo.partnerType, payload.getPartnerType());
        }
        // 合作方
        if (payload.getCollaborator() != null) {
            update.set(qdo.collaborator, payload.getCollaborator());
        }
        // 基于
        if (payload.getBase() != null) {
            update.set(qdo.base, payload.getBase());
        }
        // 比例
        if (payload.getProportion() != null) {
            update.set(qdo.proportion, payload.getProportion());
        }
        // 金额
        if (payload.getAmt() != null) {
            update.set(qdo.amt, payload.getAmt());
        }
        // 税费率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 税费
        if (payload.getTaxCost() != null) {
            update.set(qdo.taxCost, payload.getTaxCost());
        }
        // 税费承担方
        if (payload.getTaxPayer() != null) {
            update.set(qdo.taxPayer, payload.getTaxPayer());
        }
        // 净支付额
        if (payload.getNetPay() != null) {
            update.set(qdo.netPay, payload.getNetPay());
        }
        // 具体支付方式
        if (payload.getPaymentMethod() != null) {
            update.set(qdo.paymentMethod, payload.getPaymentMethod());
        }
        // 线下合同&沟通签署状态
        if (payload.getContractStatus() != null) {
            update.set(qdo.contractStatus, payload.getContractStatus());
        }
        // 联系人姓名
        if (payload.getLiaisonName() != null) {
            update.set(qdo.liaisonName, payload.getLiaisonName());
        }
        // 联系电话
        if (payload.getLiaisonPhone() != null) {
            update.set(qdo.liaisonPhone, payload.getLiaisonPhone());
        }
        // 关联单据类型
        if (payload.getDocType() != null) {
            update.set(qdo.docType, payload.getDocType());
        }
        // 关联单据号
        if (payload.getDocumentNumber() != null) {
            update.set(qdo.documentNumber, payload.getDocumentNumber());
        }
        // 明细状态
        if (payload.getDetailedStatus() != null) {
            update.set(qdo.detailedStatus, payload.getDetailedStatus());
        }
        // 父明细
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }

        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getCostCondIdV4() != null) {
            update.set(qdo.costCondIdV4, payload.getCostCondIdV4());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 外包费用确认单ID
            if (nullFields.contains("epibolyCostConId")) {
                update.setNull(qdo.epibolyCostConId);
            }
            // 工作类型
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 具体理由
            if (nullFields.contains("reason")) {
                update.setNull(qdo.reason);
            }
            // 伙伴类型
            if (nullFields.contains("partnerType")) {
                update.setNull(qdo.partnerType);
            }
            // 合作方
            if (nullFields.contains("collaborator")) {
                update.setNull(qdo.collaborator);
            }
            // 基于
            if (nullFields.contains("base")) {
                update.setNull(qdo.base);
            }
            // 比例
            if (nullFields.contains("proportion")) {
                update.setNull(qdo.proportion);
            }
            // 金额
            if (nullFields.contains("amt")) {
                update.setNull(qdo.amt);
            }
            // 税费率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 税费
            if (nullFields.contains("taxCost")) {
                update.setNull(qdo.taxCost);
            }
            // 税费承担方
            if (nullFields.contains("taxPayer")) {
                update.setNull(qdo.taxPayer);
            }
            // 净支付额
            if (nullFields.contains("netPay")) {
                update.setNull(qdo.netPay);
            }
            // 具体支付方式
            if (nullFields.contains("paymentMethod")) {
                update.setNull(qdo.paymentMethod);
            }
            // 线下合同&沟通签署状态
            if (nullFields.contains("contractStatus")) {
                update.setNull(qdo.contractStatus);
            }
            // 联系人姓名
            if (nullFields.contains("liaisonName")) {
                update.setNull(qdo.liaisonName);
            }
            // 联系电话
            if (nullFields.contains("liaisonPhone")) {
                update.setNull(qdo.liaisonPhone);
            }
            // 关联单据类型
            if (nullFields.contains("docType")) {
                update.setNull(qdo.docType);
            }
            // 关联单据号
            if (nullFields.contains("documentNumber")) {
                update.setNull(qdo.documentNumber);
            }
            // 明细状态
            if (nullFields.contains("detailedStatus")) {
                update.setNull(qdo.detailedStatus);
            }
            // 父明细
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            if (nullFields.contains("costCondIdV4")) {
                update.setNull(qdo.costCondIdV4);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据外包费用确认单查询对应的明细（一对一）
     *
     * @param epibolyCostConId
     * @return ConEpibolyCostConDVO
     */
    public List<ConEpibolyCostConDVO> queryByepibolyCostConId(Long epibolyCostConId) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.epibolyCostConId.eq(epibolyCostConId));
        jpaQuery.where(qdo.parentId.isNull());
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 根据父ID查询子明细
     *
     * @param parentId
     * @return
     */
    public List<ConEpibolyCostConDVO> queryByParentId(Long parentId) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.parentId.eq(parentId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }


    /**
     * 根据父Id集合查询子明细
     *
     * @param patentIds 父Ids
     * @return 子明细
     */
    public List<ConEpibolyCostConDVO> queryByParentIdIn(List<Long> patentIds) {
        JPAQuery<ConEpibolyCostConDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.parentId.in(patentIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 修改子合同有效合同金额
     *
     * @param newEffectiveAmt
     * @param contractId
     */
    public void updateSubConEffectiveAmt(BigDecimal newEffectiveAmt, Long contractId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoCon);
        update.set(qdoCon.effectiveAmt, newEffectiveAmt);
        update.where(qdoCon.id.eq(contractId)).execute();
    }

    /**
     * 取消采购合同和外包费用关联
     *
     * @param purContractNoList
     * @return
     */
    public long cancelPurContract(List<String> purContractNoList) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.docType, "")
                .set(qdo.documentNumber, "")
                .where(qdo.documentNumber.in(purContractNoList));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * @param conEpibolyCostConDId
     * @param contractNo
     */
    public void updateChannelCostConIdNumber(Long conEpibolyCostConDId, String contractNo) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.set(qdo.documentNumber, contractNo);
        update.set(qdo.docType, "采购合同");
        update.where(qdo.id.eq(conEpibolyCostConDId)).execute();
    }

    public long unbindReim(String reimNo) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.setNull(qdo.documentNumber);
        update.setNull(qdo.docType);
        update.where(qdo.documentNumber.eq(reimNo));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

