package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
public interface ConReceivableRepo extends JpaRepository<ConReceivableDO, Long>, JpaSpecificationExecutor<ConReceivableDO> {


    ConReceivableDO queryDistinctFirstByRecvClassAndSourceIdAndDeleteFlagOrderByCreateTimeDesc(String recvClass,Long id,Integer deleteFlag);

    @Query(value = " select * from con_receivable e where e.modify_time >= ?1  ", nativeQuery = true)
    List<ConReceivableDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ConReceivableDO set conReceivableIdV4=?1,modifyTime=current_time  where id=?2")
    @Modifying
    void updateConReceivableIdV4(Long idV4, Long id);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_receivable set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);
}
