package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarShareVO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarShareDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdCalendarShareDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdCalendarShareRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zoey
 * @Description:日程共享成员
 * @date 2022/4/21 - 11:47
 */
@Repository
@RequiredArgsConstructor
public class PrdCalendarShareDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdCalendarShareRepo repo;
    private final QPrdCalendarShareDO qdo = QPrdCalendarShareDO.prdCalendarShareDO;
    private final QPrdCalendarDO cdo = QPrdCalendarDO.prdCalendarDO;


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdCalendarShareDO save(PrdCalendarShareDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<PrdCalendarShareVO> getJpaQuerySelect() {
        JPAQuery<PrdCalendarShareVO> jpaQuery=jpaQueryFactory.select(Projections.bean(PrdCalendarShareVO.class,
                qdo.id,
                qdo.userId,
                qdo.calId,
                qdo.readonly,
                qdo.createUserId
        )).from(qdo).leftJoin(cdo).on(cdo.id.longValue().eq(qdo.calId));
        return jpaQuery;
    }


    public List<PrdCalendarShareVO> queryByCalId(Long calId) {
        JPAQuery<PrdCalendarShareVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.calId.eq(calId));
        return jpaQuery.fetch();
    }

    public List<PrdCalendarShareVO> queryByUserId(Long userId) {
        JPAQuery<PrdCalendarShareVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(cdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.userId.eq(userId));
        return jpaQuery.fetch();
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }
}
