package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRulePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRuleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigRuleService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRuleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Api(tags = "易稻壳yeedoc通用文档类型配置规则表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessDocTypeConfigRule")
@Slf4j
public class BusinessDocTypeConfigRuleController {

private final BusinessDocTypeConfigRuleService businessDocTypeConfigRuleService;

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-新增")
    public TwOutputUtil<BusinessDocTypeConfigRuleVO> insert(@RequestBody BusinessDocTypeConfigRulePayload payload){
         return TwOutputUtil.ok(businessDocTypeConfigRuleService.insert(payload));
    }

    // /**
    //  * 易稻壳yeedoc通用文档类型配置规则表-更新
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping
    // @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-更新")
    // public TwOutputUtil<BusinessDocTypeConfigRuleVO> update(@RequestBody BusinessDocTypeConfigRulePayload payload){
    //     return TwOutputUtil.ok(businessDocTypeConfigRuleService.update(payload));
    // }

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeConfigRulePayload payload){
        return TwOutputUtil.ok(businessDocTypeConfigRuleService.updateByKeyDynamic(payload));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-主键查询")
    public TwOutputUtil<BusinessDocTypeConfigRuleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeConfigRuleService.queryByKey(key));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeConfigRuleVO>> paging(BusinessDocTypeConfigRuleQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigRuleService.queryPaging(query));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-查询列表")
    public TwOutputUtil<List<BusinessDocTypeConfigRuleVO>> queryList(BusinessDocTypeConfigRuleQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigRuleService.queryListDynamic(query));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置规则表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("易稻壳yeedoc通用文档类型配置规则表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessDocTypeConfigRuleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

