package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypePermissionPrevRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypePermissionPrevRecordService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 通用文档-易稻壳赋权预览地址获取记录表
 *
 * @author duwh
 * @date 2023-12-09
 */
@Api(tags = "通用文档-易稻壳赋权预览地址获取记录表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessDocTypePermissionPrewRecord")
@Slf4j
public class BusinessDocTypePermissionPrevRecordController {

private final BusinessDocTypePermissionPrevRecordService businessDocTypePermissionPrewRecordService;

    // /**
    //  * 通用文档-易稻壳赋权预览地址获取记录表-新增
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PostMapping
    // @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-新增")
    // public TwOutputUtil<BusinessDocTypePermissionPrevRecordVO> insert(@RequestBody BusinessDocTypePermissionPrevRecordPayload payload){
    //      return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.insert(payload));
    // }
    //
    // /**
    //  * 通用文档-易稻壳赋权预览地址获取记录表-更新
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping
    // @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-更新")
    // public TwOutputUtil<BusinessDocTypePermissionPrevRecordVO> update(@RequestBody BusinessDocTypePermissionPrevRecordPayload payload){
    //     return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.update(payload));
    // }
    //
    // /**
    //  * 通用文档-易稻壳赋权预览地址获取记录表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping("update")
    // @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    // public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypePermissionPrevRecordPayload payload){
    //     return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.updateByKeyDynamic(payload));
    // }

    /**
     * 通用文档-易稻壳赋权预览地址获取记录表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-主键查询")
    public TwOutputUtil<BusinessDocTypePermissionPrevRecordVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.queryByKey(key));
    }

    /**
     * 通用文档-易稻壳赋权预览地址获取记录表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypePermissionPrevRecordVO>> paging(BusinessDocTypePermissionPrevRecordQuery query) {
        return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.queryPaging(query));
    }

    /**
     * 通用文档-易稻壳赋权预览地址获取记录表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-查询列表")
    public TwOutputUtil<List<BusinessDocTypePermissionPrevRecordVO>> queryList(BusinessDocTypePermissionPrevRecordQuery query) {
        return TwOutputUtil.ok(businessDocTypePermissionPrewRecordService.queryListDynamic(query));
    }

    // /**
    //  * 通用文档-易稻壳赋权预览地址获取记录表-删除
    //  *
    //  * @param keys 主键id
    //  * @return result
    //  */
    // @DeleteMapping("/deleteSoft")
    // @ApiOperation("通用文档-易稻壳赋权预览地址获取记录表-删除")
    // public TwOutputUtil deleteSoft(Long[] keys) {
    //      businessDocTypePermissionPrewRecordService.deleteSoft(Arrays.asList(keys));
    //     return TwOutputUtil.ok();
    // }

}

