package com.elitesland.tw.tw5.server.common.permission.strategy.context;

import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import org.apache.xmlbeans.impl.common.ConcurrentReaderHashMap;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 14:03
 **/
@Component
public class BusinessObjectTypeStrategyContext {

    private final Map<String, BusinessObjectTypeStrategyService> businessObjectTypeStrategyMap = new ConcurrentHashMap();

    /**
     * 通过构造器注入的方式 拿到策略下的策略实现类
     *
     * @param strategyMap
     */
    public BusinessObjectTypeStrategyContext(Map<String, BusinessObjectTypeStrategyService> strategyMap) {

        businessObjectTypeStrategyMap.clear();
        businessObjectTypeStrategyMap.putAll(strategyMap);

    }

    /**
     * 获取对应策略下可以使用的bean
     *
     * @param beanName
     * @return
     */
    public BusinessObjectTypeStrategyService getStrategyBean(String beanName) {
        return businessObjectTypeStrategyMap.get(beanName);
    }

}
