package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.OrgUserStrategyService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 10:02
 **/
@Service(value = "ORG_ALL_USERS_IN_ORGANIZATION_AND_LOWER_LEVELS")
@RequiredArgsConstructor
public class OrgUserAllUsersInOrgAndLower implements OrgUserStrategyService {

    private final CacheUtil cacheUtil;

    /**
     * 本级组织及下级组织下的所有用户情况下的执行
     *
     * @param rule  权限规则
     * @param defaultOrgId  用户默认组织
     * @param childOrgSet   用户组织及子组织
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, Long defaultOrgId, Set<Long> childOrgSet) {

        List<Long> ruleChildOrgIds = cacheUtil.getAllChildOrgIds(Long.parseLong(rule.getRuleScope()));
        Set<Long> ruleChildOrgSet = new HashSet<>(ruleChildOrgIds);
        for (Long childOrg : ruleChildOrgSet) {
            if (!childOrgSet.add(childOrg)) {
                return true;
            }
        }
        return false;

    }

}
