package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBudgetItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBudgetItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBudgetItemService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 预算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Api(tags = "预算项目管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accBudgetItem")
@Slf4j
public class AccBudgetItemController {

    private final AccBudgetItemService accBudgetItemService;

    /**
     * 预算项目管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("预算项目管理-新增")
    public TwOutputUtil<AccBudgetItemVO> insert(@RequestBody AccBudgetItemPayload payload) {
        return TwOutputUtil.ok(accBudgetItemService.insert(payload));
    }

    /**
     * 预算项目管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("预算项目管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccBudgetItemPayload payload) {
        return TwOutputUtil.ok(accBudgetItemService.updateByKeyDynamic(payload));
    }

    /**
     * 预算项目管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("预算项目管理-主键查询")
    public TwOutputUtil<AccBudgetItemVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accBudgetItemService.queryByKey(key));
    }

    /**
     * 预算项目管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("预算项目管理-分页")
    public TwOutputUtil<PagingVO<AccBudgetItemVO>> paging(AccBudgetItemQuery query) {
        return TwOutputUtil.ok(accBudgetItemService.queryPaging(query));
    }

    /**
     * 预算项目管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("预算项目管理-查询列表")
    public TwOutputUtil<List<AccBudgetItemVO>> queryList(AccBudgetItemQuery query) {
        return TwOutputUtil.ok(accBudgetItemService.queryListDynamic(query));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response, AccBudgetItemQuery query) {
        accBudgetItemService.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file) {
        accBudgetItemService.batchImport(file);
        return TwOutputUtil.ok();
    }
//    /**
//     * 预算项目管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("预算项目管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        accBudgetItemService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

