package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;

/**
 * @author sunxw
 * @description 特殊费用报销流程服务
 * @Date 2023/11/28
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "ACC_OTHERS" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class AccReimOthersCallbackController implements WorkflowCallBack {

    //流程节点信息
    enum FlowTaskKey {
        Activity_1luosio("Activity_1luosio", "直属上级审批"),
        Activity_0cn8khq("Activity_0cn8khq", "财务稽核专员"),
        Activity_0lbdadr("Activity_0lbdadr", "财务负责人"),
        Activity_0co8b7h("Activity_0co8b7h", "总裁"),
        Activity_0yd0oo0("Activity_0yd0oo0", "费用承担事业部负责人"),

        ;

        private String code;
        private String desc;

        FlowTaskKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    private final AccReimService accReimService;
    private final InvInvoiceService invInvoiceService;
    private final AdmFeeApplyService admFeeApplyService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(Long.parseLong(businessKey));
        //待收单
        if (FlowTaskKey.Activity_0yd0oo0.code.equals(taskKey)) {
            accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
        }
        //财务负责人
        if (FlowTaskKey.Activity_0lbdadr.code.equals(taskKey)) {
            accReimPayload.setFinPicApprTime(LocalDateTime.now());
        }
        accReimService.partialUpdate(accReimPayload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        Long reimId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(reimId);
        //根据业务key查询当前业务对象
        AccReimVO accReimVO = accReimService.queryOneByKey(reimId);
        if (!ObjectUtils.isEmpty(accReimVO)) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.NOTSUBMIT.name());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //解绑发票
                    invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    //解绑特殊费用申请单
                    admFeeApplyService.unbindReim(reimId);
                    break;
                case INVALID://先删除流程再删除单据
                    accReimPayload.setApprStatus(ProcInstStatus.INVALID.name());
                    accReimPayload.setDeleteFlag(1);
                    //解绑发票
                    invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    //解绑特殊费用申请单
                    admFeeApplyService.unbindReim(reimId);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.REJECTED.name());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if (FlowTaskKey.Activity_0cn8khq.code.equals(taskDefKey)) {
                        accReimPayload.setFinRejectFlag(1);
                    }
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    //流程通过为待记账
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVED.name());
                    invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVED.getCode());
                    break;
                case APPROVING:
                    //accReimPayload.setReimStatus(AccReimDocStatusEnum.APPLYING.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVING.name());
                    break;
            }
            accReimService.partialUpdate(accReimPayload);
        }
        return WorkflowResult.success(null);
    }

}
