package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * 行政模块相关流程回调
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "AMD_{procDefKey}" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class AdmWorkflowCallBackController implements WorkflowCallBack {
    private final AdmBusitripApplyService admBusitripApplyService;
    private final AdmFeeApplyService admFeeApplyService;

    enum ProcDefKey {
        AMD_BUSITRIP_APPLY("AMD_BUSITRIP_APPLY", "出差申请流程"),
        AMD_FEE_APPLY("AMD_FEE_APPLY", "特殊费用申请流程"),
        ;

        ProcDefKey(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        private String name;
        private String desc;
    }

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {

        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);

        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        try {
            if (payload.getProcDefKey().equals(ProcDefKey.AMD_BUSITRIP_APPLY.name)) {
                log.info("出差申请流程状态变化回调");
                //出差申请流程状态变化回调service
                admBusitripApplyService.processStatusChange(payload);
            }
            if (payload.getProcDefKey().equals(ProcDefKey.AMD_FEE_APPLY.name)) {
                log.info("特殊费用申请流程状态变化回调");
                //特殊费用申请流程状态变化回调service
                admFeeApplyService.processStatusChange(payload);
            }
            return WorkflowResult.success(null);
        } catch (TwException ex) {
            WorkflowResult result = new WorkflowResult(false, ex.getErrors().toString(), null);
            return result;
        }
    }
}
