package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 合伙人模块相关枚举
 *
 * @author carl
 * @since 2024/06/25
 */
public interface CopartnerEnum {
    /**
     * 考核点
     */
    enum Point implements CopartnerEnum {
        point1("point1", "自签单贡献"),
        point2("point2", "售前支持贡献(已成单)"),
        point3("point3", "项目交付贡献"),
        point4("point4", "售前支持贡献(未成单)"),
        point5("point5", "日常管理运营业务开拓贡献"),

        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;


        Point(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 流程定义key
     */
    enum ProcDefKey implements CopartnerEnum {
        COPARTNER_REPORT("COPARTNER_REPORT", "合伙人绩效自述流程"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;


        ProcDefKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

}
