package com.elitesland.tw.tw5.server.prd.copartner.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigUserService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Api(tags = "合伙人绩效自述员工表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/copartner/performanceReadmeConfigUser")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.COPARTNER_PERFORMANCE)
public class PerformanceReadmeConfigUserController {

    private final PerformanceReadmeConfigUserService performanceReadmeConfigUserService;

//    /**
//     * 合伙人绩效自述员工表-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("合伙人绩效自述员工表-新增")
//    public TwOutputUtil<PerformanceReadmeConfigUserVO> insert(@RequestBody PerformanceReadmeConfigUserPayload payload) {
//        return TwOutputUtil.ok(performanceReadmeConfigUserService.insert(payload));
//    }


    /**
     * 合伙人绩效自述员工表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("procInstUpdate")
    @ApiOperation("合伙人绩效自述员工表-流程实例更新")
    public TwOutputUtil<Long> procInstUpdate(@RequestBody PerformanceReadmeConfigUserPayload payload) {
        performanceReadmeConfigUserService.procInstUpdate(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 合伙人绩效自述员工表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述员工表-主键查询")
    public TwOutputUtil<PerformanceReadmeConfigUserVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(performanceReadmeConfigUserService.queryByKey(key));
    }

    /**
     * 合伙人绩效自述员工表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/paging")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述员工表-分页")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.COPARTNER_PERFORMANCE_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PerformanceReadmeConfigUserVO>> paging(@RequestBody PerformanceReadmeConfigUserQuery query) {
        return TwOutputUtil.ok(performanceReadmeConfigUserService.queryPaging(query));
    }

    /**
     * 合伙人绩效自述员工表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("合伙人绩效自述员工表-查询列表")
    public TwOutputUtil<List<PerformanceReadmeConfigUserVO>> queryList(PerformanceReadmeConfigUserQuery query) {
        return TwOutputUtil.ok(performanceReadmeConfigUserService.queryListDynamic(query));
    }

    /**
     * 合伙人绩效自述员工表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合伙人绩效自述员工表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        performanceReadmeConfigUserService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

