package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdIndividAbilityVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdIndividAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdAbilityLevelDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdIndividAbilityDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力RepoProc
 */

@Component
public class PrdIndividAbilityDao extends BaseRepoProc<PrdIndividAbilityDO> {

    private static final QPrdIndividAbilityDO qPrdIndividAbilityDO = QPrdIndividAbilityDO.prdIndividAbilityDO;
    private static final QPrdAbilityLevelDO qPrdAbilityLevelDO = QPrdAbilityLevelDO.prdAbilityLevelDO;


    protected PrdIndividAbilityDao() {

        super(qPrdIndividAbilityDO);

    }


    public PagingVO<PrdIndividAbilityVO> page(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        JPAQuery<PrdIndividAbilityVO> query =
                select(PrdIndividAbilityVO.class)
                        .where(bulidPredicate(prdIndividAbilityQuery));
        prdIndividAbilityQuery.setPaging(query);
        prdIndividAbilityQuery.fillOrders(query, qPrdIndividAbilityDO);
        return PagingVO.<PrdIndividAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdIndividAbilityDO)
                .set(qPrdIndividAbilityDO.deleteFlag, 1)
                .where(qPrdIndividAbilityDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdIndividAbilityVO get(Long id) {

        PrdIndividAbilityVO prdIndividAbilityVO = select(PrdIndividAbilityVO.class)
                .where(qPrdIndividAbilityDO.id.eq(id))
                .fetchOne();

        return prdIndividAbilityVO;

    }


    public List<PrdIndividAbilityVO> getList(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        List<PrdIndividAbilityVO> res =
                select(PrdIndividAbilityVO.class)
                        .where(bulidPredicate(prdIndividAbilityQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdIndividAbilityDO.name,
                        qPrdIndividAbilityDO.docNo,
                        qPrdIndividAbilityDO.showFlag,
                        qPrdIndividAbilityDO.cateType1,
                        qPrdIndividAbilityDO.cateType2,
                        qPrdIndividAbilityDO.state,
                        qPrdIndividAbilityDO.levelId,
                        qPrdIndividAbilityDO.levelName,
                        qPrdIndividAbilityDO.abilityDesc,
                        qPrdIndividAbilityDO.id,
                        qPrdIndividAbilityDO.createTime,
                        qPrdIndividAbilityDO.remark

                )).from(qPrdIndividAbilityDO);

    }


    private Predicate bulidPredicate(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(prdIndividAbilityQuery.getName()), qPrdIndividAbilityDO.name, prdIndividAbilityQuery.getName())
                .andEq(StringUtils.isNotBlank(prdIndividAbilityQuery.getDocNo()), qPrdIndividAbilityDO.docNo, prdIndividAbilityQuery.getDocNo())
                .andEq(null != prdIndividAbilityQuery.getShowFlag(), qPrdIndividAbilityDO.showFlag, prdIndividAbilityQuery.getShowFlag())
                .andEq(StringUtils.isNotBlank(prdIndividAbilityQuery.getCateType1()), qPrdIndividAbilityDO.cateType1, prdIndividAbilityQuery.getCateType1())
                .andEq(StringUtils.isNotBlank(prdIndividAbilityQuery.getCateType2()), qPrdIndividAbilityDO.cateType2, prdIndividAbilityQuery.getCateType2())
                .andEq(null != prdIndividAbilityQuery.getState(), qPrdIndividAbilityDO.state, prdIndividAbilityQuery.getState())
                .andEq(null != prdIndividAbilityQuery.getLevelId(), qPrdIndividAbilityDO.levelId, prdIndividAbilityQuery.getLevelId())
                .andEq(StringUtils.isNotBlank(prdIndividAbilityQuery.getLevelName()), qPrdIndividAbilityDO.levelName, prdIndividAbilityQuery.getLevelName())
                .andEq(StringUtils.isNotBlank(prdIndividAbilityQuery.getAbilityDesc()), qPrdIndividAbilityDO.abilityDesc, prdIndividAbilityQuery.getAbilityDesc())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 能力名称
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getName())) {
            predicates.add(qPrdIndividAbilityDO.name.eq(prdIndividAbilityQuery.getName()));
        }
        // 编号
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getDocNo())) {
            predicates.add(qPrdIndividAbilityDO.docNo.eq(prdIndividAbilityQuery.getDocNo()));
        }
        // 是否显示
        if (null != prdIndividAbilityQuery.getShowFlag()) {
            predicates.add(qPrdIndividAbilityDO.showFlag.eq(prdIndividAbilityQuery.getShowFlag()));
        }
        // 分类1
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getCateType1())) {
            predicates.add(qPrdIndividAbilityDO.cateType1.eq(prdIndividAbilityQuery.getCateType1()));
        }
        // 分类2
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getCateType2())) {
            predicates.add(qPrdIndividAbilityDO.cateType2.eq(prdIndividAbilityQuery.getCateType2()));
        }
        // 状态
        if (null != prdIndividAbilityQuery.getState()) {
            predicates.add(qPrdIndividAbilityDO.state.eq(prdIndividAbilityQuery.getState()));
        }
        // 级别id
        if (null != prdIndividAbilityQuery.getLevelId()) {
            predicates.add(qPrdIndividAbilityDO.levelId.eq(prdIndividAbilityQuery.getLevelId()));
        }
        // 级别名称
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getLevelName())) {
            predicates.add(qPrdIndividAbilityDO.levelName.eq(prdIndividAbilityQuery.getLevelName()));
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdIndividAbilityQuery.getAbilityDesc())) {
            predicates.add(qPrdIndividAbilityDO.abilityDesc.eq(prdIndividAbilityQuery.getAbilityDesc()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        long res = select(PrdIndividAbilityVO.class)
                .where(bulidPredicates(prdIndividAbilityQuery))
                .fetchCount();
        return res;
    }

    public Long updateShow(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        long res = jpaQueryFactory.update(qPrdIndividAbilityDO)
                .set(qPrdIndividAbilityDO.showFlag, prdIndividAbilityPayload.getShowFlag())
                .where(qPrdIndividAbilityDO.id.eq(prdIndividAbilityPayload.getId()))
                .execute();
        return res;
    }

    public Long updateState(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        long res = jpaQueryFactory.update(qPrdIndividAbilityDO)
                .set(qPrdIndividAbilityDO.state, prdIndividAbilityPayload.getState())
                .where(qPrdIndividAbilityDO.id.eq(prdIndividAbilityPayload.getId()))
                .execute();
        return res;
    }

    public PagingVO<PrdIndividAbilityVO> levelPage(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        JPAQuery<PrdIndividAbilityVO> query = jpaQueryFactory.select(Projections.bean(PrdIndividAbilityVO.class,
                        qPrdIndividAbilityDO.name,
                        qPrdIndividAbilityDO.docNo,
                        qPrdIndividAbilityDO.cateType1,
                        qPrdIndividAbilityDO.cateType2,
                        qPrdIndividAbilityDO.state,
                        qPrdIndividAbilityDO.levelName,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdIndividAbilityDO.id,
                        qPrdAbilityLevelDO.levelDtlName,
                        qPrdAbilityLevelDO.id.as("abilityLevelId")

                )).from(qPrdIndividAbilityDO).join(qPrdAbilityLevelDO)
                .on(qPrdIndividAbilityDO.id.eq(qPrdAbilityLevelDO.abilityId))
                .where(bulidPredicate(prdIndividAbilityQuery))
                .where(qPrdAbilityLevelDO.deleteFlag.eq(0));

        prdIndividAbilityQuery.setPaging(query);
        prdIndividAbilityQuery.fillOrders(query, qPrdIndividAbilityDO);
        return PagingVO.<PrdIndividAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<PrdIndividAbilityVO> levelList(PrdIndividAbilityQuery prdIndividAbilityQuery) {

        return jpaQueryFactory.select(Projections.bean(PrdIndividAbilityVO.class,
                        qPrdIndividAbilityDO.name,
                        qPrdIndividAbilityDO.docNo,
                        qPrdIndividAbilityDO.cateType1,
                        qPrdIndividAbilityDO.cateType2,
                        qPrdIndividAbilityDO.state,
                        qPrdIndividAbilityDO.levelName,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdAbilityLevelDO.id,
                        qPrdAbilityLevelDO.levelDtlName,
                        qPrdAbilityLevelDO.id.as("abilityLevelId")

                )).from(qPrdIndividAbilityDO).join(qPrdAbilityLevelDO)
                .on(qPrdIndividAbilityDO.id.eq(qPrdAbilityLevelDO.abilityId))
                .where(bulidPredicate(prdIndividAbilityQuery))
                .where(qPrdAbilityLevelDO.deleteFlag.eq(0))
                .fetch();

    }

}

