package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 能力级别定义
 */
 
@Entity
@Table(name="prd_ability_level")
@org.hibernate.annotations.Table(appliesTo = "prd_ability_level", comment = "能力级别定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdAbilityLevelDO extends BaseModel {


    /**
     * 能力id
     */
    @Column(name = "ability_id", columnDefinition = "bigint(20) comment '能力id'")
    private Long abilityId;
    
    /**
     * 级别明细id
     */
    @Column(name = "level_dtl_id", columnDefinition = "bigint(20) comment '级别明细id'")
    private Long levelDtlId;
    
    /**
     * 级别明细名称
     */
    @Column(name = "level_dtl_name", columnDefinition = "varchar(255) comment '级别明细名称'")
    private String levelDtlName;
    
    /**
     * 类型 1单项能力2复合能力
     */
    @Column(name = "type", columnDefinition = "int(11) comment '类型 1单项能力2复合能力'")
    private Integer type;
    
    /**
     * 获取方式
     */
    @Column(name = "obtain_type", columnDefinition = "varchar(255) comment '获取方式'")
    private String obtainType;
    
    /**
     * 当量系数
     */
    @Column(name = "dl_ratio", columnDefinition = "decimal(18,4) comment '当量系数'")
    private BigDecimal dlRatio;
    
    /**
     * 能力描述
     */
    @Column(name = "ability_desc", columnDefinition = "varchar(500) comment '能力描述'")
    private String abilityDesc;
    
    /**
     * 审核人类型
     */
    @Column(name = "auditor_type", columnDefinition = "varchar(255) comment '审核人类型'")
    private String auditorType;
    
    /**
     * 审核人id
     */
    @Column(name = "auditor_id", columnDefinition = "bigint(20) comment '审核人id'")
    private Long auditorId;
    
    /**
     * 审核人名称
     */
    @Column(name = "auditor_name", columnDefinition = "varchar(255) comment '审核人名称'")
    private String auditorName;
    

}

