package com.elitesland.tw.tw5.server.prd.humanresources.basebu.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseBuChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.Arrays;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更
 */

@RestController
@RequestMapping("/api/prdBaseBuChange")
@RequiredArgsConstructor
@Api(value = "baseBu变更", tags = {"baseBu变更"})
public class PrdBaseBuChangeController {

    private final PrdBaseBuChangeService prdBaseBuChangeService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-baseBu变更")
    public TwOutputUtil<PrdBaseBuChangeVO> get(@PathVariable Long id) {

        PrdBaseBuChangeVO res = prdBaseBuChangeService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-baseBu变更")
    @GlobalTransactional
    public TwOutputUtil<Long> save(@RequestBody PrdBaseBuChangePayload prdBaseBuChangePayload) {

        PrdBaseBuChangeVO res = prdBaseBuChangeService.save(prdBaseBuChangePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-baseBu变更")
    public TwOutputUtil<Long> update(@RequestBody PrdBaseBuChangePayload prdBaseBuChangePayload) {

        PrdBaseBuChangeVO res = prdBaseBuChangeService.update(prdBaseBuChangePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-baseBu变更")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdBaseBuChangeService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-baseBu变更")
    public TwOutputUtil<PagingVO<PrdBaseBuChangeVO>> page(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        PagingVO<PrdBaseBuChangeVO> res = prdBaseBuChangeService.page(prdBaseBuChangeQuery);
        return TwOutputUtil.ok(res);

    }

//
//     @GetMapping("getCheckList")
//     @ApiOperation("详情-baseBu变更")
//     public TwOutputUtil<PrdBaseBuChangeVO> get(@PathVariable Long id) {
//
//         PrdBaseBuChangeVO res = prdBaseBuChangeService.get(id);
//         return TwOutputUtil.ok(res);
//
//     }


    @PostMapping("updateByCondition")
    @ApiOperation("条件修改-baseBu变更")
    public TwOutputUtil<Long> updateByCondition(@RequestBody PrdBaseBuChangePayload prdBaseBuChangePayload) {

        Long res = prdBaseBuChangeService.updateByCondition(prdBaseBuChangePayload);
        return TwOutputUtil.ok(res);

    }


}

