package com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseRegionChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.QPrdBaseRegionChangeDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseRegionChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请RepoProc
 */

@Component
public class PrdBaseRegionChangeDao extends BaseRepoProc<PrdBaseRegionChangeDO> {

    private static final QPrdBaseRegionChangeDO qPrdBaseRegionChangeDO = QPrdBaseRegionChangeDO.prdBaseRegionChangeDO;


    protected PrdBaseRegionChangeDao() {

        super(qPrdBaseRegionChangeDO);

    }


    public PagingVO<PrdBaseRegionChangeVO> page(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        JPAQuery<PrdBaseRegionChangeVO> query =
                select(PrdBaseRegionChangeVO.class)
                        .where(bulidPredicate(prdBaseRegionChangeQuery));
        prdBaseRegionChangeQuery.setPaging(query);
        prdBaseRegionChangeQuery.fillOrders(query, qPrdBaseRegionChangeDO);
        return PagingVO.<PrdBaseRegionChangeVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdBaseRegionChangeDO)
                .set(qPrdBaseRegionChangeDO.deleteFlag, 1)
                .where(qPrdBaseRegionChangeDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdBaseRegionChangeVO get(Long id) {

        PrdBaseRegionChangeVO prdBaseRegionChangeVO = select(PrdBaseRegionChangeVO.class)
                .where(qPrdBaseRegionChangeDO.id.eq(id))
                .fetchOne();
        if (null == prdBaseRegionChangeVO) {
            throw new BusinessException("id不正确，未找到数据");
        }
        return prdBaseRegionChangeVO;

    }


    public List<PrdBaseRegionChangeVO> getList(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        List<PrdBaseRegionChangeVO> res =
                select(PrdBaseRegionChangeVO.class)
                        .where(bulidPredicate(prdBaseRegionChangeQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdBaseRegionChangeDO.applyUserId,
                        qPrdBaseRegionChangeDO.applyUser,
                        qPrdBaseRegionChangeDO.applyDate,
                        qPrdBaseRegionChangeDO.entryDate,
                        qPrdBaseRegionChangeDO.cooperateType,
                        qPrdBaseRegionChangeDO.ouId,
                        qPrdBaseRegionChangeDO.ouName,
                        qPrdBaseRegionChangeDO.baseBuId,
                        qPrdBaseRegionChangeDO.oldBaseRegion,
                        qPrdBaseRegionChangeDO.newBaseRegion,
                        qPrdBaseRegionChangeDO.oldSocialRegion,
                        qPrdBaseRegionChangeDO.newSocialRegion,
                        qPrdBaseRegionChangeDO.changeReason,
                        qPrdBaseRegionChangeDO.activeDate,
                        qPrdBaseRegionChangeDO.applyState,
                        qPrdBaseRegionChangeDO.newCost,
                        qPrdBaseRegionChangeDO.id,
                        qPrdBaseRegionChangeDO.createTime,
                        qPrdBaseRegionChangeDO.remark

                )).from(qPrdBaseRegionChangeDO);

    }


    private Predicate bulidPredicate(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdBaseRegionChangeQuery.getApplyUserId(), qPrdBaseRegionChangeDO.applyUserId, prdBaseRegionChangeQuery.getApplyUserId())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getApplyUser()), qPrdBaseRegionChangeDO.applyUser, prdBaseRegionChangeQuery.getApplyUser())
                .andEq(null != prdBaseRegionChangeQuery.getApplyDate(), qPrdBaseRegionChangeDO.applyDate, prdBaseRegionChangeQuery.getApplyDate())
                .andEq(null != prdBaseRegionChangeQuery.getEntryDate(), qPrdBaseRegionChangeDO.entryDate, prdBaseRegionChangeQuery.getEntryDate())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getCooperateType()), qPrdBaseRegionChangeDO.cooperateType, prdBaseRegionChangeQuery.getCooperateType())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getOuId()), qPrdBaseRegionChangeDO.ouId, prdBaseRegionChangeQuery.getOuId())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getOuName()), qPrdBaseRegionChangeDO.ouName, prdBaseRegionChangeQuery.getOuName())
                .andEq(null != prdBaseRegionChangeQuery.getBaseBuId(), qPrdBaseRegionChangeDO.baseBuId, prdBaseRegionChangeQuery.getBaseBuId())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getOldBaseRegion()), qPrdBaseRegionChangeDO.oldBaseRegion, prdBaseRegionChangeQuery.getOldBaseRegion())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getNewBaseRegion()), qPrdBaseRegionChangeDO.newBaseRegion, prdBaseRegionChangeQuery.getNewBaseRegion())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getOldSocialRegion()), qPrdBaseRegionChangeDO.oldSocialRegion, prdBaseRegionChangeQuery.getOldSocialRegion())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getNewSocialRegion()), qPrdBaseRegionChangeDO.newSocialRegion, prdBaseRegionChangeQuery.getNewSocialRegion())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getChangeReason()), qPrdBaseRegionChangeDO.changeReason, prdBaseRegionChangeQuery.getChangeReason())
                .andEq(null != prdBaseRegionChangeQuery.getActiveDate(), qPrdBaseRegionChangeDO.activeDate, prdBaseRegionChangeQuery.getActiveDate())
                .andEq(StringUtils.isNotBlank(prdBaseRegionChangeQuery.getApplyState()), qPrdBaseRegionChangeDO.applyState, prdBaseRegionChangeQuery.getApplyState())
                .andEq(null != prdBaseRegionChangeQuery.getNewCost(), qPrdBaseRegionChangeDO.newCost, prdBaseRegionChangeQuery.getNewCost())
                .andEq(null != prdBaseRegionChangeQuery.getProcInstStatus(), qPrdBaseRegionChangeDO.procInstStatus, prdBaseRegionChangeQuery.getProcInstStatus())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 申请人id
        if (null != prdBaseRegionChangeQuery.getApplyUserId()) {
            predicates.add(qPrdBaseRegionChangeDO.applyUserId.eq(prdBaseRegionChangeQuery.getApplyUserId()));
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getApplyUser())) {
            predicates.add(qPrdBaseRegionChangeDO.applyUser.eq(prdBaseRegionChangeQuery.getApplyUser()));
        }
        // 申请日期
        if (null != prdBaseRegionChangeQuery.getApplyDate()) {
            predicates.add(qPrdBaseRegionChangeDO.applyDate.eq(prdBaseRegionChangeQuery.getApplyDate()));
        }
        // 入职日期
        if (null != prdBaseRegionChangeQuery.getEntryDate()) {
            predicates.add(qPrdBaseRegionChangeDO.entryDate.eq(prdBaseRegionChangeQuery.getEntryDate()));
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getCooperateType())) {
            predicates.add(qPrdBaseRegionChangeDO.cooperateType.eq(prdBaseRegionChangeQuery.getCooperateType()));
        }
        // 公司id
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getOuId())) {
            predicates.add(qPrdBaseRegionChangeDO.ouId.eq(prdBaseRegionChangeQuery.getOuId()));
        }
        // 公司名称
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getOuName())) {
            predicates.add(qPrdBaseRegionChangeDO.ouName.eq(prdBaseRegionChangeQuery.getOuName()));
        }
        // basebu
        if (null != prdBaseRegionChangeQuery.getBaseBuId()) {
            predicates.add(qPrdBaseRegionChangeDO.baseBuId.eq(prdBaseRegionChangeQuery.getBaseBuId()));
        }
        // 原base地
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getOldBaseRegion())) {
            predicates.add(qPrdBaseRegionChangeDO.oldBaseRegion.eq(prdBaseRegionChangeQuery.getOldBaseRegion()));
        }
        // 新base地
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getNewBaseRegion())) {
            predicates.add(qPrdBaseRegionChangeDO.newBaseRegion.eq(prdBaseRegionChangeQuery.getNewBaseRegion()));
        }
        // 原社保缴纳地
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getOldSocialRegion())) {
            predicates.add(qPrdBaseRegionChangeDO.oldSocialRegion.eq(prdBaseRegionChangeQuery.getOldSocialRegion()));
        }
        // 新社保缴纳地
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getNewSocialRegion())) {
            predicates.add(qPrdBaseRegionChangeDO.newSocialRegion.eq(prdBaseRegionChangeQuery.getNewSocialRegion()));
        }
        // 变更原因
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getChangeReason())) {
            predicates.add(qPrdBaseRegionChangeDO.changeReason.eq(prdBaseRegionChangeQuery.getChangeReason()));
        }
        // 生效日期
        if (null != prdBaseRegionChangeQuery.getActiveDate()) {
            predicates.add(qPrdBaseRegionChangeDO.activeDate.eq(prdBaseRegionChangeQuery.getActiveDate()));
        }
        // 审批状态
        if (StringUtils.isNotEmpty(prdBaseRegionChangeQuery.getApplyState())) {
            predicates.add(qPrdBaseRegionChangeDO.applyState.eq(prdBaseRegionChangeQuery.getApplyState()));
        }
        // 新增成本
        if (null != prdBaseRegionChangeQuery.getNewCost()) {
            predicates.add(qPrdBaseRegionChangeDO.newCost.eq(prdBaseRegionChangeQuery.getNewCost()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        long res = select(PrdBaseRegionChangeVO.class)
                .where(bulidPredicate(prdBaseRegionChangeQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdBaseRegionChangeDO);

        // 申请人id
        if (null != prdBaseRegionChangePayload.getApplyUserId()) {
            update.set(qPrdBaseRegionChangeDO.applyUserId, prdBaseRegionChangePayload.getApplyUserId());
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getApplyUser())) {
            update.set(qPrdBaseRegionChangeDO.applyUser, prdBaseRegionChangePayload.getApplyUser());
        }
        // 申请日期
        if (null != prdBaseRegionChangePayload.getApplyDate()) {
            update.set(qPrdBaseRegionChangeDO.applyDate, prdBaseRegionChangePayload.getApplyDate());
        }
        // 入职日期
        if (null != prdBaseRegionChangePayload.getEntryDate()) {
            update.set(qPrdBaseRegionChangeDO.entryDate, prdBaseRegionChangePayload.getEntryDate());
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getCooperateType())) {
            update.set(qPrdBaseRegionChangeDO.cooperateType, prdBaseRegionChangePayload.getCooperateType());
        }
        // 公司id
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getOuId())) {
            update.set(qPrdBaseRegionChangeDO.ouId, prdBaseRegionChangePayload.getOuId());
        }
        // 公司名称
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getOuName())) {
            update.set(qPrdBaseRegionChangeDO.ouName, prdBaseRegionChangePayload.getOuName());
        }
        // basebu
        if (null != prdBaseRegionChangePayload.getBaseBuId()) {
            update.set(qPrdBaseRegionChangeDO.baseBuId, prdBaseRegionChangePayload.getBaseBuId());
        }
        // 原base地
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getOldBaseRegion())) {
            update.set(qPrdBaseRegionChangeDO.oldBaseRegion, prdBaseRegionChangePayload.getOldBaseRegion());
        }
        // 新base地
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getNewBaseRegion())) {
            update.set(qPrdBaseRegionChangeDO.newBaseRegion, prdBaseRegionChangePayload.getNewBaseRegion());
        }
        // 原社保缴纳地
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getOldSocialRegion())) {
            update.set(qPrdBaseRegionChangeDO.oldSocialRegion, prdBaseRegionChangePayload.getOldSocialRegion());
        }
        // 新社保缴纳地
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getNewSocialRegion())) {
            update.set(qPrdBaseRegionChangeDO.newSocialRegion, prdBaseRegionChangePayload.getNewSocialRegion());
        }
        // 变更原因
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getChangeReason())) {
            update.set(qPrdBaseRegionChangeDO.changeReason, prdBaseRegionChangePayload.getChangeReason());
        }
        // 生效日期
        if (null != prdBaseRegionChangePayload.getActiveDate()) {
            update.set(qPrdBaseRegionChangeDO.activeDate, prdBaseRegionChangePayload.getActiveDate());
        }
        // 审批状态
        if (StringUtils.isNotEmpty(prdBaseRegionChangePayload.getApplyState())) {
            update.set(qPrdBaseRegionChangeDO.applyState, prdBaseRegionChangePayload.getApplyState());
        }
        // 新增成本
        if (null != prdBaseRegionChangePayload.getNewCost()) {
            update.set(qPrdBaseRegionChangeDO.newCost, prdBaseRegionChangePayload.getNewCost());
        }
        // 流程示例id
        if (null != prdBaseRegionChangePayload.getProcInstId()) {
            update.set(qPrdBaseRegionChangeDO.procInstId, prdBaseRegionChangePayload.getProcInstId());
        }
        // 新增成本
        if (null != prdBaseRegionChangePayload.getProcInstStatus()) {
            update.set(qPrdBaseRegionChangeDO.procInstStatus, prdBaseRegionChangePayload.getProcInstStatus());
        }
        // 新增成本
        if (null != prdBaseRegionChangePayload.getSubmitTime()) {
            update.set(qPrdBaseRegionChangeDO.submitTime, prdBaseRegionChangePayload.getSubmitTime());
        }
        // 新增成本
        if (null != prdBaseRegionChangePayload.getApprovedTime()) {
            update.set(qPrdBaseRegionChangeDO.approvedTime, prdBaseRegionChangePayload.getApprovedTime());
        }
        long res = update.where(qPrdBaseRegionChangeDO.id.eq(prdBaseRegionChangePayload.getId()))
                .execute();
        return res;

    }

}

